/// <reference types="lib.es2017.observable" />
import { IRedisConnection } from '@signageos/lib/dist/Redis/redisConnectionFactory';
import { IApplet } from '../../Schema/Applet/appletModel';
import { IDevice } from '../../Schema/Device/deviceModel';
import { ITiming, TimingCreateValues, ITimingIdentification, ITimingModel, TimingUpdateValues } from '../../Schema/Timing/timingModel';
export declare const createTimingModel: (conn: IRedisConnection, sourceModel: ITimingModel<ITiming>) => {
    create(_appletRow: Pick<IApplet, 'uid'>, deviceRow: IDevice, values: TimingCreateValues): Promise<void>;
    update(timingRow: ITimingIdentification, _values: TimingUpdateValues): Promise<void>;
    remove(timingRow: ITimingIdentification): Promise<void>;
    observeByUid(timingUid: string): Promise<Observable<{
        old_val: ITiming | null;
        new_val: ITiming;
        clusterTime: import("bson").Timestamp;
    }, Error>>;
    observeListByDevice(device: IDevice): Promise<Observable<ITiming[], Error>>;
};
//# sourceMappingURL=timingModel.d.ts.map