"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTermsAgreementModel = void 0;
const helper_1 = require("../helper");
const termsAccountIdVersionKeyPrefix = 'terms.accountId-version';
function getTermsAccountIdVersionKey(accountId, version) {
    return `${termsAccountIdVersionKeyPrefix}.${accountId}-${version}`;
}
const createTermsAgreementModel = (conn) => {
    function observeTermsAgreementByAccountIdAndVersion(accountId, version) {
        const termsKey = getTermsAccountIdVersionKey(accountId, version);
        return new Promise((resolve, _reject) => {
            const observable = (0, helper_1.observe)(conn, termsKey);
            observable.forEach((changes) => {
                if (changes.new_val.accountId === accountId && changes.new_val.termsVersion === version) {
                    resolve(changes.new_val);
                }
            });
        });
    }
    return {
        waitForAgreedTermsByAccountIdAndVersion(accountId, version) {
            return __awaiter(this, void 0, void 0, function* () {
                const firstChanges = yield observeTermsAgreementByAccountIdAndVersion(accountId, version);
                return firstChanges;
            });
        },
        markTermsAgreed(termsAgreement) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, helper_1.updateOne)(conn, getTermsAccountIdVersionKey(termsAgreement.accountId, termsAgreement.termsVersion), termsAgreement);
            });
        },
    };
};
exports.createTermsAgreementModel = createTermsAgreementModel;
//# sourceMappingURL=termsModel.js.map