"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSocketRateModel = void 0;
const generator_1 = require("@signageos/lib/dist/Hash/generator");
const helper_1 = require("../../Redis/helper");
const OPTIONS_KEY = 'socketRate_options';
const RATE_PREFIX = 'socketRate_hourly.';
const HOUR_IN_SECONDS = 60 * 60;
const HOUR_IN_MS = HOUR_IN_SECONDS * 1e3;
const KEEP_HISTORY_HOURS = 24;
function createSocketRateModel(redisConnection) {
    function getHourRateKey(timestampMs) {
        const hourBeginningTimestamp = Math.floor(timestampMs / HOUR_IN_MS) * HOUR_IN_MS;
        return RATE_PREFIX + hourBeginningTimestamp;
    }
    return {
        increaseConnectionsCount(connectedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                const timestampMs = connectedAt.valueOf();
                const hourRateKey = getHourRateKey(timestampMs);
                yield (0, helper_1.addToOrderedSet)(redisConnection, hourRateKey, timestampMs, `${timestampMs}-${(0, generator_1.generateUniqueHash)(6)}`);
                // Remove history after a while to prevent memory leak in redis
                yield (0, helper_1.setExpiration)(redisConnection, hourRateKey, KEEP_HISTORY_HOURS * HOUR_IN_SECONDS);
            });
        },
        isConnectionLimitReached(connectedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                const options = yield this.getOptions();
                if (!options) {
                    // If period and limit not set, it's unlimited
                    return false;
                }
                const currentCount = yield this.getConnectionsCount(connectedAt, options.periodMs);
                return currentCount > options.limit;
            });
        },
        getConnectionsCount(connectedAt, periodMs) {
            return __awaiter(this, void 0, void 0, function* () {
                if (periodMs > HOUR_IN_MS) {
                    throw new Error(`Currently the maximum period is an hour`);
                }
                const currentTimestampMs = connectedAt.valueOf();
                const currentHourRateKey = getHourRateKey(currentTimestampMs);
                const lastHourRateKey = getHourRateKey(currentTimestampMs - HOUR_IN_MS);
                const limitTimestampMs = currentTimestampMs - periodMs;
                const currentHourCount = yield (0, helper_1.countOrderedSet)(redisConnection, currentHourRateKey, limitTimestampMs, currentTimestampMs);
                const lastHourCount = yield (0, helper_1.countOrderedSet)(redisConnection, lastHourRateKey, limitTimestampMs, currentTimestampMs);
                return currentHourCount + lastHourCount;
            });
        },
        setOptions(options) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, helper_1.createOne)(redisConnection, OPTIONS_KEY, options);
            });
        },
        getOptions() {
            return __awaiter(this, void 0, void 0, function* () {
                return yield (0, helper_1.getOne)(redisConnection, OPTIONS_KEY);
            });
        },
    };
}
exports.createSocketRateModel = createSocketRateModel;
//# sourceMappingURL=socketRateModel.js.map