"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createApiRequestsModel = void 0;
const helper_1 = require("../helper");
const requestsUidKeyPrefix = 'requests';
function getRequestUidKey(organization, resource, method, dateTime) {
    return `${requestsUidKeyPrefix}.${organization}.${resource}.${method}.${dateTime}`;
}
const createApiRequestsModel = (conn) => ({
    fetchListByOrigination(organizationUid) {
        return __awaiter(this, void 0, void 0, function* () {
            const organizationKeys = yield (0, helper_1.getKeysByPattern)(conn, `${requestsUidKeyPrefix}.${organizationUid}.*`);
            const requests = [];
            for (const organization of organizationKeys) {
                const request = yield (0, helper_1.getAllOfHash)(conn, organization);
                if (request !== null) {
                    const parsedRequest = {
                        accountUid: JSON.parse(request.accountUid),
                        companyUid: JSON.parse(request.companyUid),
                        organizationUid: JSON.parse(request.organizationUid),
                        createdAt: new Date(request.createdAt),
                        createdAtHour: JSON.parse(request.createdAtHour),
                        resource: JSON.parse(request.resource),
                        method: JSON.parse(request.method),
                        count: JSON.parse(request.count.toString()),
                    };
                    requests.push(parsedRequest);
                }
            }
            return requests;
        });
    },
    fetchAllRequestFromLastHour(lastTime) {
        return __awaiter(this, void 0, void 0, function* () {
            const allRequestKeys = yield (0, helper_1.getKeysByPattern)(conn, `${requestsUidKeyPrefix}.*.*.*.${lastTime}`);
            const requests = [];
            for (const organizationUi of allRequestKeys) {
                const request = yield (0, helper_1.getAllOfHash)(conn, organizationUi);
                if (request !== null) {
                    const parsedRequest = {
                        accountUid: JSON.parse(request.accountUid),
                        companyUid: JSON.parse(request.companyUid),
                        organizationUid: JSON.parse(request.organizationUid),
                        createdAt: new Date(request.createdAt),
                        createdAtHour: JSON.parse(request.createdAtHour),
                        resource: JSON.parse(request.resource),
                        method: JSON.parse(request.method),
                        count: JSON.parse(request.count.toString()),
                    };
                    requests.push(parsedRequest);
                }
            }
            return requests;
        });
    },
    countRequest(requestCount) {
        return __awaiter(this, void 0, void 0, function* () {
            const { organizationUid, resource, account, company, method, dateTime } = requestCount;
            const requestOrganizationKey = getRequestUidKey(organizationUid, resource, method, dateTime.getHours().toString());
            if (!(yield (0, helper_1.getAllOfHash)(conn, requestOrganizationKey))) {
                yield (0, helper_1.createAndAddToHash)(conn, requestOrganizationKey, 'organization', organizationUid);
                yield (0, helper_1.createAndAddToHash)(conn, requestOrganizationKey, 'organizationUid', organizationUid);
                yield (0, helper_1.createAndAddToHash)(conn, requestOrganizationKey, 'accountUid', account);
                yield (0, helper_1.createAndAddToHash)(conn, requestOrganizationKey, 'companyUid', company);
                yield (0, helper_1.createAndAddToHash)(conn, requestOrganizationKey, 'resource', resource);
                yield (0, helper_1.createAndAddToHash)(conn, requestOrganizationKey, 'method', method);
                yield (0, helper_1.createAndAddToHash)(conn, requestOrganizationKey, 'createdAt', dateTime.toString());
                yield (0, helper_1.createAndAddToHash)(conn, requestOrganizationKey, 'createdAtHour', dateTime.getUTCHours());
                yield (0, helper_1.createAndIncrementInHash)(conn, requestOrganizationKey, 'count', 1);
            }
            else {
                yield (0, helper_1.createAndIncrementInHash)(conn, requestOrganizationKey, 'count', 1);
            }
        });
    },
    deleteRequest(requestData) {
        return __awaiter(this, void 0, void 0, function* () {
            const { organizationUid, resource, method, hour } = requestData;
            const allRequestKeys = yield (0, helper_1.getKeysByPattern)(conn, `${requestsUidKeyPrefix}.${organizationUid}.${resource}.${method}.${hour}*`);
            if (allRequestKeys.length !== 1) {
                return;
            }
            return yield (0, helper_1.deleteOne)(conn, allRequestKeys[0]);
        });
    },
});
exports.createApiRequestsModel = createApiRequestsModel;
//# sourceMappingURL=requestModel.js.map