"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPolicyModel = void 0;
const _ = require("lodash");
const helper_1 = require("../helper");
const policyUidKeyPrefix = 'policy.uid';
function getPolicyUidKey(uid) {
    return `${policyUidKeyPrefix}.${uid}`;
}
const policyOrganizationUidKeyPrefix = 'policy.organizationUid';
function getPolicyOrganizationUidKey(organizationUid) {
    return `${policyOrganizationUidKeyPrefix}.${organizationUid}`;
}
const createPolicyModel = (conn) => {
    function updatePolicyPartial(policyPartial) {
        return __awaiter(this, void 0, void 0, function* () {
            const policyUidOnly = _.pick(policyPartial, 'uid');
            yield (0, helper_1.updatePartialOne)(conn, getPolicyUidKey(policyPartial.uid), policyUidOnly);
            yield (0, helper_1.updatePartialOne)(conn, getPolicyOrganizationUidKey(policyPartial.organizationUid), policyUidOnly);
        });
    }
    return {
        create(uid, _name, organization, _items) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updatePolicyPartial({ uid, organizationUid: organization.uid });
            });
        },
        updateName(policyRow, _name) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updatePolicyPartial({ uid: policyRow.uid, organizationUid: policyRow.organizationUid });
            });
        },
        updateItems(policyRow, _items) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updatePolicyPartial({ uid: policyRow.uid, organizationUid: policyRow.organizationUid });
            });
        },
        remove(policyRow) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updatePolicyPartial({ uid: policyRow.uid, organizationUid: policyRow.organizationUid });
            });
        },
    };
};
exports.createPolicyModel = createPolicyModel;
//# sourceMappingURL=policyModel.js.map