"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceInstalledPackageModelRedis = void 0;
const helper_1 = require("../helper");
const helpers_1 = require("@signageos/lib/dist/Observable/helpers");
const installedPackagePrefix = 'deviceInstalledPackage.deviceUid';
function getInstalledPackagePrefixUidKey(deviceUid) {
    return `${installedPackagePrefix}.${deviceUid}`;
}
const createDeviceInstalledPackageModelRedis = (conn, sourceModel) => {
    return {
        observeListByDevice(device) {
            return __awaiter(this, void 0, void 0, function* () {
                const observable = (0, helper_1.observe)(conn, getInstalledPackagePrefixUidKey(device.identityHash));
                return (0, helpers_1.asyncMap)(observable, (_changes) => __awaiter(this, void 0, void 0, function* () {
                    return yield sourceModel.fetchListByDevice(device);
                }));
            });
        },
        create(uid, device, _buildHash, _specs, _createdAt) {
            return __awaiter(this, void 0, void 0, function* () {
                return yield (0, helper_1.updatePartialOne)(conn, getInstalledPackagePrefixUidKey(device.identityHash), { uid });
            });
        },
        delete(device, buildHash) {
            return __awaiter(this, void 0, void 0, function* () {
                return yield (0, helper_1.updateOnDelete)(conn, getInstalledPackagePrefixUidKey(device.identityHash), {
                    buildHash,
                });
            });
        },
    };
};
exports.createDeviceInstalledPackageModelRedis = createDeviceInstalledPackageModelRedis;
//# sourceMappingURL=deviceInstalledPackageModel.js.map