"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createOrganizationModel = void 0;
const helpers_1 = require("@signageos/lib/dist/Observable/helpers");
const waitUntil_1 = require("@signageos/lib/dist/DateTime/waitUntil");
const helper_1 = require("../helper");
const observation_1 = require("../../Helpers/observation");
const organizationUidKeyPrefix = 'organization.uid';
function getOrganizationUidKey(uid) {
    return `${organizationUidKeyPrefix}.${uid}`;
}
const organizationAccountIdKeyPrefix = 'organization.accountId';
function getOrganizationAccountIdKey(accountId) {
    return `${organizationAccountIdKeyPrefix}.${accountId}`;
}
const organizationNameKeyPrefix = 'organization.name';
function getOrganizationNameKey(name) {
    return `${organizationNameKeyPrefix}.${name}`;
}
const organizationTitleKeyPrefix = 'organization.title';
function getOrganizationTitleKey(title) {
    return `${organizationTitleKeyPrefix}.${title}`;
}
const organizationAllKey = 'organization.all';
const createOrganizationModel = (conn, sourceModel) => {
    function updateOrganizationPartial(organizationIdentification) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const organization = yield sourceModel.fetchByUid(organizationIdentification.uid);
            yield (0, helper_1.updatePartialOne)(conn, organizationAllKey, organizationIdentification);
            yield (0, helper_1.updatePartialOne)(conn, getOrganizationUidKey(organizationIdentification.uid), organizationIdentification);
            if (organization) {
                for (const accountId of (_a = organization.accountIds) !== null && _a !== void 0 ? _a : []) {
                    yield (0, helper_1.updatePartialOne)(conn, getOrganizationAccountIdKey(accountId), organizationIdentification);
                }
                yield (0, helper_1.updatePartialOne)(conn, getOrganizationNameKey(organization.name), organizationIdentification);
                yield (0, helper_1.updatePartialOne)(conn, getOrganizationTitleKey(organization.title), organizationIdentification);
            }
        });
    }
    function updateOrganizationOnRemove(organization) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updateOnDelete)(conn, organizationAllKey, organization);
            yield (0, helper_1.updateOnDelete)(conn, getOrganizationUidKey(organization.uid), organization);
        });
    }
    function observeOrganization(organizationKey) {
        const observable = (0, helper_1.observe)(conn, organizationKey);
        return (0, helpers_1.asyncMap)(observable, (changes) => __awaiter(this, void 0, void 0, function* () {
            if (changes.new_partial_val !== null && typeof changes.new_partial_val !== 'undefined') {
                const organization = yield (0, waitUntil_1.waitUntilNotNull)(() => __awaiter(this, void 0, void 0, function* () {
                    return yield sourceModel.fetchByUid(changes.new_partial_val.uid);
                }));
                return {
                    old_val: { uid: changes.new_partial_val.uid },
                    new_val: organization,
                    clusterTime: changes.clusterTime,
                };
            }
            else {
                return {
                    old_val: changes.old_val,
                    new_val: changes.new_val,
                    clusterTime: changes.clusterTime,
                };
            }
        }));
    }
    return {
        fetchByUid(uid) {
            return __awaiter(this, void 0, void 0, function* () {
                const existingOrganization = yield sourceModel.fetchByUid(uid);
                if (existingOrganization) {
                    return existingOrganization;
                }
                return null;
            });
        },
        createCompany(uid, _name, _title, _oauthClientId, _oauthClientSecret, _createdAt, _billingPlan, _iconUrl) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial({
                    uid,
                });
            });
        },
        updateCompany(_params) {
            return __awaiter(this, void 0, void 0, function* () {
                throw new Error(`Not implemented method.`);
            });
        },
        createOrganization(uid, _name, _title, _oauthClientId, _oauthClientSecret, _createdAt, _subscriptionType, _iconUrl) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial({
                    uid,
                });
            });
        },
        updateTitle(org, _title) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(org);
            });
        },
        updateIconUrl(org, _iconUrl) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(org);
            });
        },
        updateDefaultLocationMarker(org, _defaultLocationMarker) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(org);
            });
        },
        updateVPNUrl(org, _vpnServerNameTag) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(org);
            });
        },
        deleteVPNUrl(org) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(org);
            });
        },
        updateBillingInfo(org, _billingInfo) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(org);
            });
        },
        updateBillingPlan(org, _billingPlan) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(org);
            });
        },
        changeSubscriptionType(org, _subscriptionType) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(org);
            });
        },
        setDefaultSubscriptionType(org, _subscriptionType) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(org);
            });
        },
        assignAccount(org, _account, _assignedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(org);
            });
        },
        removeAccount(org, _account) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(org);
            });
        },
        remove(org) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationOnRemove(org);
            });
        },
        observeByUid(uid) {
            return __awaiter(this, void 0, void 0, function* () {
                return observeOrganization(getOrganizationUidKey(uid));
            });
        },
        observeListByAccount(options) {
            return __awaiter(this, void 0, void 0, function* () {
                const { account } = options;
                const observable = observeOrganization(getOrganizationAccountIdKey(account.id));
                return (0, helpers_1.asyncMap)(observable, (changes) => __awaiter(this, void 0, void 0, function* () {
                    if (changes.new_val !== null && typeof changes.new_val !== 'undefined') {
                        return yield sourceModel.fetchSortedListByFilterAndAccount(options);
                    }
                    else {
                        return {
                            companies: [],
                            organizations: [],
                            organizationsTotalCount: 0,
                        };
                    }
                }));
            });
        },
        observeAllOrganizationsList() {
            return __awaiter(this, void 0, void 0, function* () {
                return observeOrganization(organizationAllKey);
            });
        },
        waitByName(name) {
            return __awaiter(this, void 0, void 0, function* () {
                const firstChanges = yield (0, observation_1.waitForFirstNonNull)(observeOrganization(getOrganizationNameKey(name)));
                return firstChanges.new_val;
            });
        },
        setParent(org, _parentalOrganizationRow) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(org);
            });
        },
        unsetParent(org) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(org);
            });
        },
        updateProductionSince(org, _productionSince) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(org);
            });
        },
        deleteProductionSince(org) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(org);
            });
        },
        updateMaxDevicesCount(org, _maxDevicesCount) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(org);
            });
        },
        updateEndOfTrialPeriod(org, _endDate) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(org);
            });
        },
        clearEndOfTrialPeriod(org) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(org);
            });
        },
        setDeviceNameTemplate(org, _template) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(org);
            });
        },
        assignCompanyNetworkToOrganization({ organization }) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(organization);
            });
        },
        unassignCompanyNetworkFromOrganization({ organization, }) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(organization);
            });
        },
        assignWhiteLabelSettingsToOrganization({ organization, }) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(organization);
            });
        },
        unassignWhiteLabelSettingsFromOrganization(organization) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(organization);
            });
        },
        updateOrganizationReporters(organization) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationPartial(organization);
            });
        },
    };
};
exports.createOrganizationModel = createOrganizationModel;
//# sourceMappingURL=organizationModel.js.map