"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createOrganizationDetailsModel = void 0;
const helper_1 = require("../helper");
const helpers_1 = require("@signageos/lib/dist/Observable/helpers");
const waitUntil_1 = require("@signageos/lib/dist/DateTime/waitUntil");
const organizationUidKeyPrefix = 'organizationDetails.uid';
function getOrganizationUidKey(uid) {
    return `${organizationUidKeyPrefix}.${uid}`;
}
const createOrganizationDetailsModel = (conn, sourceModel) => {
    function updateOrganizationDetailsPartial(organizationDetailsPartial) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updatePartialOne)(conn, getOrganizationUidKey(organizationDetailsPartial.organizationUid), organizationDetailsPartial);
        });
    }
    function observeOrganizationDetails(organizationKey) {
        const observable = (0, helper_1.observe)(conn, organizationKey);
        return (0, helpers_1.asyncMap)(observable, (changes) => __awaiter(this, void 0, void 0, function* () {
            const organization = yield (0, waitUntil_1.waitUntilNotNull)(() => __awaiter(this, void 0, void 0, function* () {
                return yield sourceModel.fetchByOrganizationUid(changes.new_partial_val.organizationUid);
            }));
            return {
                old_val: { organizationUid: changes.new_partial_val.organizationUid },
                new_val: organization,
                clusterTime: changes.clusterTime,
            };
        }));
    }
    return {
        create(organizationUid) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationDetailsPartial({
                    organizationUid,
                });
            });
        },
        observeListByOrganizationUids(organizationUids) {
            return __awaiter(this, void 0, void 0, function* () {
                return (0, helpers_1.mergeObservables)(...organizationUids.map((organizationUid) => observeOrganizationDetails(getOrganizationUidKey(organizationUid))));
            });
        },
        updateDeviceStatistics(organizationUid, _devicesCountAll, _devicesCountWeek, _devicesCountMonth, _devicesCountLastMonth) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateOrganizationDetailsPartial({
                    organizationUid,
                });
            });
        },
    };
};
exports.createOrganizationDetailsModel = createOrganizationDetailsModel;
//# sourceMappingURL=organizationDetailsModel.js.map