"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createModel = void 0;
const modelCreatable_1 = require("./modelCreatable");
const modelUpdatable_1 = require("./modelUpdatable");
const modelDeletable_1 = require("./modelDeletable");
/**
 * Creates a full creatable, updatable and deletable model for an entity
 */
function createModel({ keysBuilder, removedKeysBuilder, conn, }) {
    return Object.assign(Object.assign(Object.assign({}, (0, modelCreatable_1.createModelCreatable)({ keysBuilder, conn })), (0, modelUpdatable_1.createModelUpdatable)({ keysBuilder, conn })), (0, modelDeletable_1.createModelDeletable)({ keysBuilder: removedKeysBuilder, conn }));
}
exports.createModel = createModel;
//# sourceMappingURL=model.js.map