"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDomainModel = void 0;
const helper_1 = require("../helper");
const databases_1 = require("../databases");
function getKey(name) {
    return `domain.${name}`;
}
function getPubSubKey(name) {
    return `domain.notification.${name}`;
}
const createDomainModel = (generalConn) => {
    const conn = generalConn.getDB(databases_1.Database.EVENT_SOURCING);
    return {
        fetchByName(name) {
            return __awaiter(this, void 0, void 0, function* () {
                return yield (0, helper_1.getOne)(conn, getKey(name));
            });
        },
        create(name, event) {
            return __awaiter(this, void 0, void 0, function* () {
                if (yield this.fetchByName(name)) {
                    throw new Error(`Domain ${name} already exists`);
                }
                const domain = {
                    name,
                    lastEventReceivedAt: event.receivedAt,
                    lastEventSecondaryIndex: event.secondaryIndex,
                };
                yield (0, helper_1.createOne)(conn, getKey(name), domain);
                yield (0, helper_1.updateOne)(conn, getPubSubKey(name), domain);
            });
        },
        update(name, event) {
            return __awaiter(this, void 0, void 0, function* () {
                if (!(yield this.fetchByName(name))) {
                    throw new Error(`Domain ${name} was not found`);
                }
                const domain = {
                    name,
                    lastEventReceivedAt: event.receivedAt,
                    lastEventSecondaryIndex: event.secondaryIndex,
                };
                yield (0, helper_1.createOne)(conn, getKey(name), domain);
                yield (0, helper_1.updateOne)(conn, getPubSubKey(name), domain);
            });
        },
        observeByName(name) {
            return __awaiter(this, void 0, void 0, function* () {
                return (0, helper_1.observe)(conn, getPubSubKey(name)).map((changes) => changes.new_val);
            });
        },
    };
};
exports.createDomainModel = createDomainModel;
//# sourceMappingURL=domainModel.js.map