"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __await = (this && this.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncGenerator = (this && this.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceAlivenessModel = void 0;
const helper_1 = require("../../helper");
const KEY_PREFIX = 'deviceAliveness.';
function getKey(duid) {
    return `${KEY_PREFIX}${duid}`;
}
function parseDuid(key) {
    return key.substring(KEY_PREFIX.length);
}
const createDeviceAlivenessModel = (conn) => ({
    fetchMapByDuids(duids) {
        return __awaiter(this, void 0, void 0, function* () {
            const deviceAlivenessMap = new Map();
            const duidKeys = duids.map((duid) => getKey(duid));
            const prefixedDeviceAlivenessMap = yield (0, helper_1.getManyMapWithKeys)(conn, duidKeys);
            //remove key prefixes
            for (const [key, value] of prefixedDeviceAlivenessMap.entries()) {
                deviceAlivenessMap.set(key.substring(KEY_PREFIX.length), value);
            }
            return deviceAlivenessMap;
        });
    },
    fetchByDuid(duid) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const alivenessMap = yield this.fetchMapByDuids([duid]);
            return (_a = alivenessMap.get(duid)) !== null && _a !== void 0 ? _a : null;
        });
    },
    markAlive(duid, aliveAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.createOne)(conn, getKey(duid), { aliveAt });
        });
    },
    fetchAllIterator() {
        return __asyncGenerator(this, arguments, function* fetchAllIterator_1() {
            let result;
            do {
                result = yield __await((0, helper_1.scanKeysByPattern)(conn, getKey('*'), {
                    cursor: (result === null || result === void 0 ? void 0 : result.nextCursor) || '0',
                }));
                for (const key of result.keys) {
                    const aliveness = yield __await((0, helper_1.getOne)(conn, key));
                    if (aliveness) {
                        const duid = parseDuid(key);
                        yield yield __await([duid, aliveness]);
                    }
                }
            } while (result.nextCursor !== '0');
        });
    },
});
exports.createDeviceAlivenessModel = createDeviceAlivenessModel;
//# sourceMappingURL=deviceAlivenessModel.js.map