"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceMonitoringLogNotificationModel = void 0;
const helper_1 = require("../../helper");
const deviceIdentityHashAndMonitoringTypePrefix = 'deviceMonitoringLog.identityHash-monitoringType';
function getDeviceIdentityHashAndMonitoringTypeKey(identityHash, monitoringType) {
    return `${deviceIdentityHashAndMonitoringTypePrefix}.${identityHash}-${monitoringType}.notification`;
}
const createDeviceMonitoringLogNotificationModel = (conn) => ({
    create(id, type, device, createdAt, data) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updateOne)(conn, getDeviceIdentityHashAndMonitoringTypeKey(device.identityHash, type), {
                id,
                deviceIdentityHash: device.identityHash,
                organizationUid: (_a = device.organizationUid) !== null && _a !== void 0 ? _a : undefined,
                type,
                createdAt,
                data,
            });
        });
    },
    createMany(_monitoringLogs) {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error(`Not implemented method.`);
        });
    },
    observeByDeviceAndTypeWithInitialData(device, type) {
        return __awaiter(this, void 0, void 0, function* () {
            const observable = (0, helper_1.observe)(conn, getDeviceIdentityHashAndMonitoringTypeKey(device.identityHash, type));
            return observable.map((changes) => changes.new_val);
        });
    },
    invalidate() {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Not implemented');
        });
    },
});
exports.createDeviceMonitoringLogNotificationModel = createDeviceMonitoringLogNotificationModel;
//# sourceMappingURL=deviceMonitoringLogNotificationModel.js.map