"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMonitoringLogsByDates = void 0;
const DeviceTelemetryType_1 = require("@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType");
const getMonitoringLogsByDates = ({ identityHashes, fetchLatestByIdentityHashAndType, }) => __awaiter(void 0, void 0, void 0, function* () {
    const monitoringLogs = [];
    for (const identityHash of identityHashes) {
        for (const type of Object.keys(DeviceTelemetryType_1.DeviceTelemetryType)) {
            const monitoringLog = yield fetchLatestByIdentityHashAndType(identityHash, type);
            if (monitoringLog) {
                monitoringLogs.push(monitoringLog);
            }
        }
    }
    return monitoringLogs;
});
exports.getMonitoringLogsByDates = getMonitoringLogsByDates;
//# sourceMappingURL=deviceMonitoringLog.utils.js.map