"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceExportLogModel = void 0;
const helpers_1 = require("@signageos/lib/dist/Observable/helpers");
const helper_1 = require("../../helper");
const _ = require("lodash");
const waitUntil_1 = require("@signageos/lib/dist/DateTime/waitUntil");
const deviceExportLogAccountIdPrefix = 'deviceExportLog.requestId-accountId';
function getDeviceExportLogRequestIdKey(requestId) {
    return `${deviceExportLogAccountIdPrefix}.${requestId}`;
}
const createDeviceExportLogModel = (conn, sourceModel) => {
    function updateDeviceExportLogPartial(deviceExportLogPartial) {
        return __awaiter(this, void 0, void 0, function* () {
            const deviceExportLog = _.pick(deviceExportLogPartial, 'requestId');
            yield (0, helper_1.updatePartialOne)(conn, getDeviceExportLogRequestIdKey(deviceExportLogPartial.requestId), deviceExportLog);
        });
    }
    function observeDeviceExportLog(deviceExportRequestIdLogKey) {
        const observable = (0, helper_1.observe)(conn, deviceExportRequestIdLogKey);
        return (0, helpers_1.asyncMap)(observable, (changes) => __awaiter(this, void 0, void 0, function* () {
            const deviceExportLog = yield (0, waitUntil_1.waitUntilNotNull)(() => __awaiter(this, void 0, void 0, function* () {
                return yield sourceModel.fetchByRequestId(changes.new_partial_val.requestId);
            }));
            if (!deviceExportLog) {
                throw new Error(`Device export log not found: ${changes.new_partial_val.requestId}`);
            }
            return deviceExportLog;
        }));
    }
    return {
        observeByRequestId(requestId) {
            return __awaiter(this, void 0, void 0, function* () {
                return observeDeviceExportLog(getDeviceExportLogRequestIdKey(requestId));
            });
        },
        create(_accountId, requestId, _startedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceExportLogPartial({
                    requestId: requestId,
                });
            });
        },
        markSucceeded(requestId, _finishedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                const partialDeviceExportLog = { requestId };
                yield updateDeviceExportLogPartial(partialDeviceExportLog);
            });
        },
        markFailed(requestId, _finishedAt, _errorMessage) {
            return __awaiter(this, void 0, void 0, function* () {
                const partialDeviceExportLog = { requestId };
                yield updateDeviceExportLogPartial(partialDeviceExportLog);
            });
        },
    };
};
exports.createDeviceExportLogModel = createDeviceExportLogModel;
//# sourceMappingURL=deviceExportLogModel.js.map