"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceActionLogModel = void 0;
const _ = require("lodash");
const helper_1 = require("../../helper");
const helpers_1 = require("@signageos/lib/dist/Observable/helpers");
const waitUntil_1 = require("@signageos/lib/dist/DateTime/waitUntil");
const deviceIdentityHashAndActionTypeKeyPrefix = 'deviceActionLog.identityHash-actionType';
function getDeviceIdentityHashAndActionTypeKey(identityHash, actionType) {
    return `${deviceIdentityHashAndActionTypeKeyPrefix}.${identityHash}-${actionType}`;
}
const createDeviceActionLogModel = (conn, sourceModel) => {
    function updateDeviceActionLogPartial(actionLogPartial) {
        return __awaiter(this, void 0, void 0, function* () {
            const actionLogUidOnly = _.pick(actionLogPartial, 'uid');
            yield (0, helper_1.updatePartialOne)(conn, getDeviceIdentityHashAndActionTypeKey(actionLogPartial.deviceIdentityHash, actionLogPartial.type), actionLogUidOnly);
        });
    }
    function observeDeviceActionLog(deviceActionLogKey) {
        const observable = (0, helper_1.observe)(conn, deviceActionLogKey);
        return (0, helpers_1.asyncMap)(observable, (changes) => __awaiter(this, void 0, void 0, function* () {
            const actionLog = yield (0, waitUntil_1.waitUntilNotNull)(() => __awaiter(this, void 0, void 0, function* () {
                return yield sourceModel.fetchByUid(changes.new_partial_val.uid);
            }));
            if (!actionLog) {
                throw new Error(`Device action log not found: ${changes.new_partial_val.uid}`);
            }
            return actionLog;
        }));
    }
    return {
        observeByDeviceAndTypeWithInitialData(device, type) {
            return __awaiter(this, void 0, void 0, function* () {
                return observeDeviceActionLog(getDeviceIdentityHashAndActionTypeKey(device.identityHash, type));
            });
        },
        create(uid, _requestId, type, device, _createdAt, _data, _originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceActionLogPartial({
                    uid,
                    deviceIdentityHash: device.identityHash,
                    type,
                });
            });
        },
        markSucceed(deviceActionLogRow, _succeedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceActionLogPartial(deviceActionLogRow);
            });
        },
        markFailed(deviceActionLogRow, _failedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceActionLogPartial(deviceActionLogRow);
            });
        },
        updateData(deviceActionLogRow, _updatedData, _updatedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceActionLogPartial(deviceActionLogRow);
            });
        },
    };
};
exports.createDeviceActionLogModel = createDeviceActionLogModel;
//# sourceMappingURL=deviceActionLogModel.js.map