"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createApplicationVersionBuildRequestModel = void 0;
const helper_1 = require("../../helper");
const helpers_1 = require("@signageos/lib/dist/Observable/helpers");
const applicationVersionBuildRequestPrefix = 'application.version.buildRequest';
const getApplicationVersionBuildRequestPrefix = (organizationUid) => {
    return `${applicationVersionBuildRequestPrefix}.organization.${organizationUid}`;
};
const allOrganizationsApplicationVersionBuildRequestsPrefix = `${applicationVersionBuildRequestPrefix}.*`;
const createApplicationVersionBuildRequestModel = (conn, sourceModel) => {
    return {
        create(applicationVersionBuildRequest) {
            return __awaiter(this, void 0, void 0, function* () {
                return yield (0, helper_1.updatePartialOne)(conn, getApplicationVersionBuildRequestPrefix(applicationVersionBuildRequest.bundledApplet.organizationUid), { requestUid: applicationVersionBuildRequest.requestUid });
            });
        },
        markBuildSucceeded(requestUid, _builtSince, _buildUrl, _directBuildUrl) {
            return __awaiter(this, void 0, void 0, function* () {
                const applicationVersionBuildRequest = yield sourceModel.fetchByRequestUid(requestUid);
                if (!applicationVersionBuildRequest) {
                    throw new Error(`ApplicationVersionBuildRequest:${requestUid} does not exist`);
                }
                return yield (0, helper_1.updatePartialOne)(conn, getApplicationVersionBuildRequestPrefix(applicationVersionBuildRequest.bundledApplet.organizationUid), { requestUid });
            });
        },
        markBuildFailed(requestUid, _failedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                const applicationVersionBuildRequest = yield sourceModel.fetchByRequestUid(requestUid);
                if (!applicationVersionBuildRequest) {
                    throw new Error(`ApplicationVersionBuildRequest:${requestUid} does not exist`);
                }
                return yield (0, helper_1.updatePartialOne)(conn, getApplicationVersionBuildRequestPrefix(applicationVersionBuildRequest.bundledApplet.organizationUid), { requestUid });
            });
        },
        observeList(args) {
            var _a;
            return __awaiter(this, void 0, void 0, function* () {
                const observables = ((_a = args.filter) === null || _a === void 0 ? void 0 : _a.organizations)
                    ? args.filter.organizations.map((organization) => (0, helper_1.observe)(conn, getApplicationVersionBuildRequestPrefix(organization.uid)))
                    : [(0, helper_1.observe)(conn, allOrganizationsApplicationVersionBuildRequestsPrefix)];
                const observable = (0, helpers_1.mergeObservables)(...observables);
                return (yield (0, helpers_1.asyncMap)(observable, () => __awaiter(this, void 0, void 0, function* () {
                    return yield sourceModel.fetchList(args);
                })));
            });
        },
    };
};
exports.createApplicationVersionBuildRequestModel = createApplicationVersionBuildRequestModel;
//# sourceMappingURL=applicationVersionBuildRequestModel.js.map