"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAppletModel = void 0;
const helper_1 = require("../helper");
const helpers_1 = require("@signageos/lib/dist/Observable/helpers");
const waitUntil_1 = require("@signageos/lib/dist/DateTime/waitUntil");
const appletUidKeyPrefix = 'applet.uid';
function getAppletUidKey(uid) {
    return `${appletUidKeyPrefix}.${uid}`;
}
const appletUidRemoveKeyPrefix = 'applet.remove.uid';
function getAppletRemoveUidKey(uid) {
    return `${appletUidRemoveKeyPrefix}.${uid}`;
}
const appletOrganizationUidKeyPrefix = 'applet.organizationUid';
function getAppletOrganizationUidKey(organizationUid) {
    return `${appletOrganizationUidKeyPrefix}.${organizationUid}`;
}
const appletOrganizationRemoveUidKeyPrefix = 'applet.remove.organizationUid';
function getAppletOrganizationRemoveUidKey(organizationUid) {
    return `${appletOrganizationRemoveUidKeyPrefix}.${organizationUid}`;
}
const createAppletModel = (conn, sourceModel) => {
    function updateAppletPartial(appletPartial) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updatePartialOne)(conn, getAppletUidKey(appletPartial.uid), appletPartial);
            yield (0, helper_1.updatePartialOne)(conn, getAppletOrganizationUidKey(appletPartial.organizationUid), appletPartial);
        });
    }
    function observeApplet(appletKey, appletRemoveKey) {
        const observableCreateAndUpdate = (0, helper_1.observe)(conn, appletKey);
        const observableRemove = (0, helper_1.observe)(conn, appletRemoveKey).map((changes) => {
            return {
                old_val: { uid: changes.new_partial_val.uid },
                new_val: null,
                clusterTime: changes.clusterTime,
            };
        });
        const observable = (0, helpers_1.asyncMap)(observableCreateAndUpdate, (changes) => __awaiter(this, void 0, void 0, function* () {
            const applet = yield (0, waitUntil_1.waitUntilNotNull)(() => __awaiter(this, void 0, void 0, function* () {
                return yield sourceModel.fetchByUid(changes.new_partial_val.uid);
            }));
            return {
                old_val: { uid: changes.new_partial_val.uid },
                new_val: applet,
                clusterTime: changes.clusterTime,
            };
        }));
        return (0, helpers_1.mergeObservables)(observableRemove, observable);
    }
    return {
        create(uid, _name, _createdAt, organizationUid, _iconUrl) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAppletPartial({ uid, organizationUid });
            });
        },
        updateName(appletRow, _name) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAppletPartial({ uid: appletRow.uid, organizationUid: appletRow.organizationUid });
            });
        },
        updateIconUrl(appletRow, _iconUrl) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAppletPartial({ uid: appletRow.uid, organizationUid: appletRow.organizationUid });
            });
        },
        updateOrganization(appletRow, organization) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAppletPartial({ uid: appletRow.uid, organizationUid: organization.uid });
            });
        },
        remove(appletRow) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, helper_1.updatePartialOne)(conn, getAppletRemoveUidKey(appletRow.uid), appletRow);
                yield (0, helper_1.updatePartialOne)(conn, getAppletOrganizationRemoveUidKey(appletRow.organizationUid), appletRow);
            });
        },
        observeByUid(uid) {
            return __awaiter(this, void 0, void 0, function* () {
                return observeApplet(getAppletUidKey(uid), getAppletRemoveUidKey(uid));
            });
        },
        observeSortedListByOrganizations(organizations, options) {
            return __awaiter(this, void 0, void 0, function* () {
                const grainObservable = (0, helpers_1.mergeObservables)(...organizations.map(({ uid }) => (0, helper_1.observe)(conn, getAppletOrganizationUidKey(uid))), ...organizations.map(({ uid }) => (0, helper_1.observe)(conn, getAppletOrganizationRemoveUidKey(uid))));
                return (0, helpers_1.asyncMap)(grainObservable, (_changes) => __awaiter(this, void 0, void 0, function* () {
                    return sourceModel.fetchSortedListByOrganizations(organizations, options);
                }));
            });
        },
    };
};
exports.createAppletModel = createAppletModel;
//# sourceMappingURL=appletModel.js.map