import { ObjectId, Timestamp } from 'mongodb';
export declare type IInsertStreamChange<TDocument> = {
    _id: ObjectId;
    operationType: 'insert' | 'replace';
    fullDocument: TDocument;
    ns: {
        db: string;
        coll: string;
    };
    documentKey: {
        _id: ObjectId;
    };
    clusterTime: Timestamp;
    txnNumber?: number;
    lsid?: any;
};
export declare type IReplaceStreamChange<TDocument> = IInsertStreamChange<TDocument>;
export declare type IUpdateStreamChange<TDocument> = {
    _id: ObjectId;
    operationType: 'update';
    fullDocument?: TDocument;
    ns: {
        db: string;
        coll: string;
    };
    documentKey: {
        _id: ObjectId;
    };
    updateDescription: {
        updatedFields: {
            [key: string]: any;
        };
        removedFields: string[];
    };
    clusterTime: Timestamp;
    txnNumber?: number;
    lsid?: any;
};
export declare type IDeleteStreamChange = {
    _id: ObjectId;
    operationType: 'delete' | 'drop' | 'invalidate';
    ns: {
        db: string;
        coll: string;
    };
    documentKey: {
        _id: ObjectId;
    };
    clusterTime: Timestamp;
    txnNumber?: number;
    lsid?: any;
};
export declare type IDropStreamChange = IDeleteStreamChange;
export declare type IInvalidateStreamChange = IDeleteStreamChange;
export declare type IRenameStreamChange = {
    _id: ObjectId;
    operationType: 'rename';
    ns: {
        db: string;
        coll: string;
    };
    to: {
        db: string;
        coll: string;
    };
    documentKey: {
        _id: ObjectId;
    };
    clusterTime: Timestamp;
    txnNumber?: number;
    lsid?: any;
};
export declare type IDropDatabaseStreamChange = {
    _id: ObjectId;
    operationType: 'dropDatabase';
    ns: {
        db: string;
    };
    documentKey: {
        _id: ObjectId;
    };
    clusterTime: Timestamp;
    txnNumber?: number;
    lsid?: any;
};
export declare type IStreamChange<TDocument> = IInsertStreamChange<TDocument> | IReplaceStreamChange<TDocument> | IUpdateStreamChange<TDocument> | IDeleteStreamChange | IDropStreamChange | IInvalidateStreamChange | IRenameStreamChange | IDropDatabaseStreamChange;
//# sourceMappingURL=changeStreams.d.ts.map