"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.partialObjectToMongoMatchQuery = void 0;
function partialObjectToMongoMatchQuery(obj, parentKey = '') {
    const query = {};
    for (const key in obj) {
        const newKey = parentKey ? `${parentKey}.${key}` : key;
        if (Array.isArray(obj[key])) {
            query[newKey] = { $in: obj[key] };
        }
        else if (typeof obj[key] === 'object' && obj[key] !== null) {
            Object.assign(query, partialObjectToMongoMatchQuery(obj[key], newKey));
        }
        else {
            query[newKey] = obj[key];
        }
    }
    return query;
}
exports.partialObjectToMongoMatchQuery = partialObjectToMongoMatchQuery;
//# sourceMappingURL=timingCommandModelUtils.js.map