"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createServerInstanceModel = exports.prepareServerInstanceTable = void 0;
const collections_1 = require("../Lib/collections");
const serverInstanceCollection = (conn) => conn.connection.collection(collections_1.Collection.ServerInstance);
const prepareServerInstanceTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield serverInstanceCollection(conn).createIndex('uid', { name: 'uid', unique: true, background: true });
});
exports.prepareServerInstanceTable = prepareServerInstanceTable;
const createServerInstanceModel = (conn) => ({
    create(uid, createdAt) {
        return __awaiter(this, void 0, void 0, function* () {
            const srv = { uid, createdAt, host: null };
            yield serverInstanceCollection(conn).insertOne(srv, { session: conn.session });
        });
    },
    fetchByUid(uid) {
        return __awaiter(this, void 0, void 0, function* () {
            return serverInstanceCollection(conn).findOne({ uid }, { session: conn.session });
        });
    },
    fetchList() {
        return __awaiter(this, void 0, void 0, function* () {
            return serverInstanceCollection(conn).find({}, { session: conn.session }).toArray();
        });
    },
    updateHost(serverInstanceRow, host) {
        return __awaiter(this, void 0, void 0, function* () {
            yield serverInstanceCollection(conn).updateOne({ uid: serverInstanceRow.uid }, { $set: { host } }, { session: conn.session });
        });
    },
    markAlive(serverInstanceRow, aliveAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield serverInstanceCollection(conn).updateOne({ uid: serverInstanceRow.uid }, { $set: { aliveAt } }, { session: conn.session });
        });
    },
    delete(serverInstanceRow, _removedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield serverInstanceCollection(conn).deleteOne({ uid: serverInstanceRow.uid }, { session: conn.session });
        });
    },
});
exports.createServerInstanceModel = createServerInstanceModel;
//# sourceMappingURL=serverInstanceModel.js.map