"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createApiRequestsModel = exports.prepareRequestTable = exports.apiRequestCollection = void 0;
const collections_1 = require("../Lib/collections");
const apiRequestCollection = (conn) => conn.connection.collection(collections_1.Collection.Requests);
exports.apiRequestCollection = apiRequestCollection;
const prepareRequestTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.apiRequestCollection)(conn).createIndex({ organizationUid: 1 }, { name: 'organization', background: true });
    yield (0, exports.apiRequestCollection)(conn).createIndex({ resource: 1 }, { name: 'resource', background: true });
    yield (0, exports.apiRequestCollection)(conn).createIndex({ account: 1 }, { name: 'account', background: true });
    yield (0, exports.apiRequestCollection)(conn).createIndex({ method: 1 }, { name: 'method', background: true });
    yield (0, exports.apiRequestCollection)(conn).createIndex({ createdAt: -1 }, { name: 'createdAt', background: true });
});
exports.prepareRequestTable = prepareRequestTable;
const createApiRequestsModel = (conn) => ({
    fetchListByOrigination(organizationUid) {
        return __awaiter(this, void 0, void 0, function* () {
            return (0, exports.apiRequestCollection)(conn).find({ organizationUid: organizationUid }, { session: conn.session }).toArray();
        });
    },
    create(requestObject) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.apiRequestCollection)(conn).insertOne(requestObject, { session: conn.session });
        });
    },
    fetchListByOrganizationWithFilter(organizationUid, filter) {
        return __awaiter(this, void 0, void 0, function* () {
            let pipeline = [];
            const { resource, method, createdFrom, createdUntil } = filter;
            pipeline.push({ $match: { organizationUid } });
            if (resource) {
                pipeline.push({ $match: { resource } });
            }
            if (method) {
                pipeline.push({ $match: { method } });
            }
            if (createdFrom && createdUntil) {
                pipeline.push({ $match: { createdAt: { $gte: new Date(createdFrom), $lt: new Date(createdUntil) } } });
            }
            pipeline.push({
                $group: {
                    _id: { path: '$resource', method: '$method' },
                    accounts: { $push: '$accountUid' },
                    requestCount: { $sum: '$count' },
                },
            }, { $project: { _id: 0, resource: '$_id', accounts: 1, requestCount: 1 } });
            return yield (0, exports.apiRequestCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
        });
    },
});
exports.createApiRequestsModel = createApiRequestsModel;
//# sourceMappingURL=apiRequestModel.js.map