"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPolicyModel = exports.preparePolicyTable = void 0;
const collections_1 = require("../Lib/collections");
const policyLogCollection = (conn) => conn.connection.collection(collections_1.Collection.PolicyLog);
// todo: migrate from postgres (replay events)
const policyCollection = (conn) => conn.connection.collection(collections_1.Collection.Policy);
const preparePolicyTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield policyCollection(conn).createIndex({ uid: 1 }, { name: 'uid', background: true });
    yield policyCollection(conn).createIndex({ organizationUid: 1 }, { name: 'organizationUid', background: true });
});
exports.preparePolicyTable = preparePolicyTable;
const createPolicyModel = (conn) => ({
    fetchByUid(uid) {
        return policyCollection(conn).findOne({ uid }, { session: conn.session });
    },
    fetchListByOrganization(organization) {
        return __awaiter(this, void 0, void 0, function* () {
            const result = policyCollection(conn).aggregate([{ $match: { organizationUid: organization.uid } }], {
                session: conn.session,
            });
            return yield result.toArray();
        });
    },
    fetchListByDeviceSortedByPriority(device) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!device.policies) {
                return [];
            }
            const policies = yield policyCollection(conn)
                .aggregate([
                {
                    $match: {
                        $expr: { $in: ['$uid', device.policies.map((policy) => policy.uid)] },
                    },
                },
            ], {
                session: conn.session,
            })
                .toArray();
            let sortHelper = {};
            for (let policyItem of device.policies) {
                sortHelper[policyItem.uid] = policyItem.priority;
            }
            return policies.sort((a, b) => sortHelper[a.uid] - sortHelper[b.uid]);
        });
    },
    fetchMergedByDevice(device) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            if (!((_a = device.policies) === null || _a === void 0 ? void 0 : _a.length)) {
                return [];
            }
            return yield policyLogCollection(conn)
                .aggregate([
                {
                    $match: {
                        $expr: { $in: ['$uid', device.policies.map((policy) => policy.uid)] },
                    },
                },
                { $sort: { updatedAt: -1 } },
                {
                    $group: {
                        _id: '$uid',
                        archived: { $first: '$archived' },
                        updatedAt: { $first: '$updatedAt' },
                        items: { $first: '$items' },
                    },
                },
                { $match: { archived: false } },
                {
                    $project: {
                        _id: 0,
                        policyUid: '$_id',
                        updatedAt: 1,
                        items: 1,
                        priority: {
                            $reduce: {
                                input: device.policies,
                                initialValue: 0,
                                in: { $cond: [{ $eq: ['$$this.uid', '$_id'] }, '$$this.priority', '$$value'] },
                            },
                        },
                        assignedAt: {
                            $reduce: {
                                input: device.policies,
                                initialValue: new Date(0),
                                in: { $cond: [{ $eq: ['$$this.uid', '$_id'] }, '$$this.assignedAt', '$$value'] },
                            },
                        },
                    },
                },
                { $unwind: '$items' },
                {
                    $match: {
                        $or: [{ 'items.applicationType': { $exists: false } }, { 'items.applicationType': device.applicationType }],
                    },
                },
                { $sort: { priority: 1 } },
                {
                    $group: {
                        _id: '$items.type',
                        type: { $last: '$items.type' },
                        value: { $last: '$items.value' },
                        policyUid: { $last: '$policyUid' },
                        updatedAt: { $last: '$updatedAt' },
                        assignedAt: { $last: '$assignedAt' },
                    },
                },
                { $project: { _id: 0 } },
            ])
                .toArray();
        });
    },
    create(uid, name, organization, items) {
        return __awaiter(this, void 0, void 0, function* () {
            yield policyCollection(conn).insertOne({
                uid,
                name,
                organizationUid: organization.uid,
                items,
            }, { session: conn.session });
        });
    },
    updateName(policyRow, name) {
        return __awaiter(this, void 0, void 0, function* () {
            yield policyCollection(conn).updateOne({
                uid: policyRow.uid,
            }, { $set: { name } }, { session: conn.session });
        });
    },
    updateItems(policyRow, items) {
        return __awaiter(this, void 0, void 0, function* () {
            yield policyCollection(conn).updateOne({ uid: policyRow.uid }, { $set: { items } }, { session: conn.session });
        });
    },
    remove(policyRow) {
        return __awaiter(this, void 0, void 0, function* () {
            yield policyCollection(conn).deleteOne({ uid: policyRow.uid }, { session: conn.session });
        });
    },
});
exports.createPolicyModel = createPolicyModel;
//# sourceMappingURL=policyModel.js.map