"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPackageModel = exports.preparePackageTable = void 0;
const bson_1 = require("bson");
const pagination_1 = require("../Lib/Pagination/pagination");
const utils_1 = require("../Lib/utils");
const collections_1 = require("../Lib/collections");
const packageCollection = (conn) => conn.connection.collection(collections_1.Collection.Package);
const preparePackageTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield packageCollection(conn).createIndex('uid', { name: 'uid', unique: true, background: true });
    yield packageCollection(conn).createIndex('packageName', { name: 'packageName', unique: true, background: true });
});
exports.preparePackageTable = preparePackageTable;
const createPackageModel = (conn) => ({
    create(uid, packageName, createdAt, label, description, ownerOrganizationUid, createdByAccountId) {
        return __awaiter(this, void 0, void 0, function* () {
            const id = new bson_1.ObjectId();
            const pkg = {
                _id: id,
                uid,
                packageName,
                createdAt,
                label,
                description,
                ownerOrganizationUid,
                createdByAccountId,
            };
            yield packageCollection(conn).insertOne(pkg, { session: conn.session });
        });
    },
    edit(uid, payload) {
        return __awaiter(this, void 0, void 0, function* () {
            if (payload.label || payload.description) {
                yield packageCollection(conn).updateOne({ uid }, {
                    $set: payload,
                });
            }
        });
    },
    fetchByUid(uid) {
        return __awaiter(this, void 0, void 0, function* () {
            return packageCollection(conn).findOne({ uid, deletedAt: null }, { session: conn.session });
        });
    },
    fetchByPackageName(packageName) {
        return __awaiter(this, void 0, void 0, function* () {
            return packageCollection(conn).findOne({ packageName, deletedAt: null }, { session: conn.session });
        });
    },
    fetchByOwnerOrganizationUid(ownerOrganizationUid) {
        return __awaiter(this, void 0, void 0, function* () {
            return packageCollection(conn)
                .find({ ownerOrganizationUid: ownerOrganizationUid, deletedAt: null }, { session: conn.session })
                .toArray();
        });
    },
    fetchList(params = {}) {
        var _a, _b;
        return __awaiter(this, void 0, void 0, function* () {
            const { filter, pagination, sort } = params;
            const orgUidFilter = (filter === null || filter === void 0 ? void 0 : filter.ownerOrganizationUids) ? { ownerOrganizationUid: { $in: filter.ownerOrganizationUids } } : {};
            const deletedAtFilter = { deletedAt: null };
            const searchRegexp = new RegExp(`${filter === null || filter === void 0 ? void 0 : filter.packageName}`, 'i');
            const nameFilter = (filter === null || filter === void 0 ? void 0 : filter.packageName)
                ? {
                    $or: [{ uid: searchRegexp }, { packageName: searchRegexp }, { label: searchRegexp }],
                }
                : {};
            const matcher = Object.assign(Object.assign(Object.assign({}, orgUidFilter), deletedAtFilter), nameFilter);
            const sortWithDefault = {
                field: (_a = sort === null || sort === void 0 ? void 0 : sort.field) !== null && _a !== void 0 ? _a : 'createdAt',
                order: (_b = sort === null || sort === void 0 ? void 0 : sort.order) !== null && _b !== void 0 ? _b : 'descending',
            };
            const { sorter, paginator } = (0, pagination_1.createSorterWithPaginator)({
                sort: sortWithDefault,
                pagination,
                since: filter === null || filter === void 0 ? void 0 : filter.createdSince,
                until: filter === null || filter === void 0 ? void 0 : filter.createdUntil,
            });
            const pipeline = (0, utils_1.getPipelineLegacy)({
                matcher,
                sorter,
                paginator,
            });
            let aggregationCursor = packageCollection(conn).aggregate(pipeline, {
                session: conn.session,
            });
            const paginatedAggregationCursor = (0, pagination_1.getPaginatedAggregationCursor)({
                aggregationCursor,
                pagination,
            });
            const packages = yield paginatedAggregationCursor.toArray();
            return packages;
        });
    },
    count(filter = {}) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const orgUidFilter = (filter === null || filter === void 0 ? void 0 : filter.ownerOrganizationUids) ? { ownerOrganizationUid: { $in: filter.ownerOrganizationUids } } : {};
            const deletedAtFilter = { deletedAt: null };
            const searchRegexp = new RegExp(`${filter === null || filter === void 0 ? void 0 : filter.packageName}`, 'i');
            const nameFilter = (filter === null || filter === void 0 ? void 0 : filter.packageName)
                ? {
                    $or: [{ uid: searchRegexp }, { packageName: searchRegexp }, { label: searchRegexp }],
                }
                : {};
            const matcher = Object.assign(Object.assign(Object.assign({}, orgUidFilter), deletedAtFilter), nameFilter);
            const [result] = yield packageCollection(conn)
                .aggregate([{ $match: matcher }, { $count: 'count' }], {
                session: conn.session,
            })
                .toArray();
            return (_a = result === null || result === void 0 ? void 0 : result.count) !== null && _a !== void 0 ? _a : 0;
        });
    },
    delete(packageToDelete, deletedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield packageCollection(conn).updateOne({ uid: packageToDelete.uid }, { $set: { deletedAt } }, { session: conn.session });
        });
    },
    fetchDeleted() {
        return __awaiter(this, void 0, void 0, function* () {
            return packageCollection(conn)
                .find({ deletedAt: { $ne: null } }, { session: conn.session })
                .toArray();
        });
    },
});
exports.createPackageModel = createPackageModel;
//# sourceMappingURL=packageModel.js.map