"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPropertyValuesPipeline = exports.getWithDeviceNumberPipeline = exports.getMatcherFromPropertyFilter = void 0;
const lodash_1 = require("lodash");
const locationModel_1 = require("../../Schema/Location/locationModel");
function getStatusMatch(status) {
    switch (status) {
        case locationModel_1.LocationStatus.ACTIVE:
            return { archivedAt: { $exists: false } };
        case locationModel_1.LocationStatus.ARCHIVED:
            return {
                archivedAt: {
                    $exists: true,
                    $type: 'date',
                },
            };
        case locationModel_1.LocationStatus.ALL:
        default:
            return null;
    }
}
function addFeaturePropertiesContextMatch({ $match, filter, }) {
    var _a;
    const featurePropertiesContextKey = 'feature.properties.context';
    const countryElemMatch = {
        $elemMatch: {
            id: /^country\./,
            text: { $in: filter === null || filter === void 0 ? void 0 : filter.countries },
        },
    };
    const regionElemMatch = {
        $elemMatch: {
            id: /^region\./,
            text: { $in: filter === null || filter === void 0 ? void 0 : filter.states },
        },
    };
    if (filter.countries && !filter.states) {
        $match[featurePropertiesContextKey] = countryElemMatch;
        return $match;
    }
    if (!filter.countries && filter.states) {
        $match[featurePropertiesContextKey] = regionElemMatch;
        return $match;
    }
    return Object.assign(Object.assign({}, $match), { $and: [
            ...((_a = $match.$and) !== null && _a !== void 0 ? _a : []),
            { [`${featurePropertiesContextKey}`]: countryElemMatch },
            { [`${featurePropertiesContextKey}`]: regionElemMatch },
        ] });
}
function getMatcherFromPropertyFilter({ filter, status = locationModel_1.LocationStatus.ACTIVE, }) {
    var _a;
    let $match = {};
    const statusMatch = getStatusMatch(status);
    if (statusMatch !== null) {
        $match = statusMatch;
    }
    if (filter === null || filter === void 0 ? void 0 : filter.name) {
        $match.$or = [{ name: { $regex: (0, lodash_1.escapeRegExp)(filter.name), $options: 'i' } }, { customId: { $regex: filter.name, $options: 'i' } }];
    }
    if (filter === null || filter === void 0 ? void 0 : filter.uids) {
        $match.uid = { $in: filter.uids };
    }
    if (filter === null || filter === void 0 ? void 0 : filter.organizationUids) {
        $match.organizationUid = { $in: filter.organizationUids };
    }
    if (filter === null || filter === void 0 ? void 0 : filter.tagUids) {
        $match.tagUids = { $all: filter.tagUids };
    }
    if (filter === null || filter === void 0 ? void 0 : filter.cities) {
        $match.city = { $in: filter.cities };
    }
    if ((filter === null || filter === void 0 ? void 0 : filter.countries) || (filter === null || filter === void 0 ? void 0 : filter.states)) {
        $match = addFeaturePropertiesContextMatch({ $match, filter });
    }
    if (filter === null || filter === void 0 ? void 0 : filter.tagsWithChildrenUids) {
        $match.$and = (_a = $match.$and) !== null && _a !== void 0 ? _a : [];
        for (const tagsWithChildrenUids of filter.tagsWithChildrenUids) {
            $match.$and.push({ tagUids: { $in: tagsWithChildrenUids } });
        }
    }
    return $match;
}
exports.getMatcherFromPropertyFilter = getMatcherFromPropertyFilter;
/**
 * @deprecated
 * This is a workaround for adding deprecated deviceNumber property to location. We need to split the pipeline
 * after the match stage (before the pagination and sorting stages) and insert some additional stages for that.
 */
function getWithDeviceNumberPipeline(pipeline) {
    const lastMatchStageIndex = pipeline.map((stage) => Object.keys(stage)[0]).lastIndexOf('$match');
    const beforeLastMatchPart = pipeline.slice(0, lastMatchStageIndex + 1);
    const afterLastMatchPart = pipeline.slice(lastMatchStageIndex + 1);
    return [
        ...beforeLastMatchPart,
        {
            $lookup: {
                from: 'device',
                localField: 'uid',
                foreignField: 'locationUid',
                as: 'deviceNumber',
            },
        },
        { $addFields: { deviceNumber: { $size: '$deviceNumber' } } },
        ...afterLastMatchPart,
    ];
}
exports.getWithDeviceNumberPipeline = getWithDeviceNumberPipeline;
function getFeatureContextPropertyValuesPipeline({ matcher, propertyKey, }) {
    let pipeline = [];
    let matchRegex;
    switch (propertyKey) {
        case 'country':
            matchRegex = /^country\./;
            break;
        case 'state':
            matchRegex = /^region\./;
            break;
        default:
            matchRegex = null;
    }
    if (matchRegex === null) {
        return pipeline;
    }
    pipeline.push({
        $match: matcher,
    }, {
        $unwind: '$feature.properties.context',
    }, {
        $match: {
            'feature.properties.context.id': matchRegex,
        },
    }, {
        $group: {
            _id: '$feature.properties.context.text',
        },
    });
    return pipeline;
}
function getPropertyValuesPipeline({ matcher, propertyKey, }) {
    let pipeline = [];
    switch (propertyKey) {
        case 'city': {
            pipeline.push({ $match: matcher }, { $group: { _id: '$city' } });
            break;
        }
        case 'tagUids': {
            pipeline.push({
                $match: Object.assign(Object.assign({}, matcher), { $and: [{ tagUids: { $exists: true } }, { tagUids: { $nin: [''] } }] }),
            }, { $project: { _id: 0, tagUids: 1 } }, { $unwind: '$tagUids' }, { $group: { _id: '$tagUids' } });
            break;
        }
        case 'country':
        case 'state': {
            pipeline.push(...getFeatureContextPropertyValuesPipeline({ matcher, propertyKey }));
            break;
        }
        default:
            return pipeline;
    }
    pipeline.push({ $sort: { _id: 1 } });
    return pipeline;
}
exports.getPropertyValuesPipeline = getPropertyValuesPipeline;
//# sourceMappingURL=locationModelUtils.js.map