"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createOwnServerLicenseModel = exports.prepareOwnServerLicenseTable = void 0;
const bson_1 = require("bson");
const collections_1 = require("../Lib/collections");
const ownServerLicenseCollection = (conn) => conn.connection.collection(collections_1.Collection.OwnServerLicense);
const prepareOwnServerLicenseTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield ownServerLicenseCollection(conn).createIndex('id', { name: 'id', unique: true, background: true });
    yield ownServerLicenseCollection(conn).createIndex('licenseKey', { name: 'licenseKey', unique: true, background: true });
});
exports.prepareOwnServerLicenseTable = prepareOwnServerLicenseTable;
const createOwnServerLicenseModel = (conn) => ({
    create(oauthClientId, oauthClientSecret, serverBaseUrl, licenseKey, licenseSecret, createdAt) {
        return __awaiter(this, void 0, void 0, function* () {
            const id = new bson_1.ObjectId();
            const license = {
                _id: id,
                id: id.toHexString(),
                oauthClientId,
                oauthClientSecret,
                serverBaseUrl,
                licenseKey,
                licenseSecret,
                createdAt,
            };
            yield ownServerLicenseCollection(conn).insertOne(license, { session: conn.session });
        });
    },
    fetchByLicenseKey(licenseKey) {
        return __awaiter(this, void 0, void 0, function* () {
            return ownServerLicenseCollection(conn).findOne({ licenseKey }, { session: conn.session });
        });
    },
    fetchAll() {
        return __awaiter(this, void 0, void 0, function* () {
            return ownServerLicenseCollection(conn).find({}, { session: conn.session }).toArray();
        });
    },
});
exports.createOwnServerLicenseModel = createOwnServerLicenseModel;
//# sourceMappingURL=ownServerLicenseModel.js.map