"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createIssuedServerLicenseValidityModel = exports.prepareIssuedServerLicenseValidityTable = void 0;
const bson_1 = require("bson");
const collections_1 = require("../Lib/collections");
const issuedServerLicenseValidityCollection = (conn) => conn.connection.collection(collections_1.Collection.IssuedServerLicenseValidity);
const prepareIssuedServerLicenseValidityTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield issuedServerLicenseValidityCollection(conn).createIndex('id', { name: 'id', unique: true, background: true });
    yield issuedServerLicenseValidityCollection(conn).createIndex('license', { name: 'license', background: true });
    yield issuedServerLicenseValidityCollection(conn).createIndex('issuedServerLicenseId', {
        name: 'issuedServerLicenseId',
        background: true,
    });
});
exports.prepareIssuedServerLicenseValidityTable = prepareIssuedServerLicenseValidityTable;
const createIssuedServerLicenseValidityModel = (conn) => ({
    create(issuedServerLicense, createdAt, expireAt, license, signature) {
        return __awaiter(this, void 0, void 0, function* () {
            const id = new bson_1.ObjectId();
            const licenseValidity = {
                _id: id,
                id: id.toHexString(),
                issuedServerLicenseId: issuedServerLicense.id,
                createdAt,
                expireAt,
                license,
                signature,
            };
            yield issuedServerLicenseValidityCollection(conn).insertOne(licenseValidity, { session: conn.session });
        });
    },
    fetchByIssuedServerLicenseAndLicense(issuedServerLicense, license) {
        return __awaiter(this, void 0, void 0, function* () {
            return issuedServerLicenseValidityCollection(conn).findOne({
                issuedServerLicenseId: issuedServerLicense.id,
                license,
            }, { session: conn.session });
        });
    },
    fetchLastByIssuedServerLicense(issuedServerLicense) {
        return __awaiter(this, void 0, void 0, function* () {
            return issuedServerLicenseValidityCollection(conn).findOne({
                issuedServerLicenseId: issuedServerLicense.id,
            }, {
                session: conn.session,
                sort: { expireAt: -1 },
            });
        });
    },
});
exports.createIssuedServerLicenseValidityModel = createIssuedServerLicenseValidityModel;
//# sourceMappingURL=issuedServerLicenseValidityModel.js.map