"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSorterWithPaginator = exports.getPaginatedAggregationCursor = void 0;
const lodash_1 = require("lodash");
const sort_1 = require("../Sort/sort");
const getLinkPaginator = ({ pagination, since, until, sort }) => {
    let linkPagination = {};
    if (!pagination) {
        return linkPagination;
    }
    if (since) {
        linkPagination = (0, lodash_1.merge)({ [`${sort.field}`]: { $gte: since } }, linkPagination);
    }
    if (until) {
        linkPagination = (0, lodash_1.merge)({ [`${sort.field}`]: { $lt: until } }, linkPagination);
    }
    return linkPagination;
};
const getPaginatedAggregationCursor = ({ aggregationCursor, pagination }) => {
    if (pagination && 'offset' in pagination && pagination.offset) {
        aggregationCursor = aggregationCursor.skip(pagination.offset);
    }
    if (pagination === null || pagination === void 0 ? void 0 : pagination.limit) {
        aggregationCursor = aggregationCursor.limit(pagination.limit);
    }
    return aggregationCursor;
};
exports.getPaginatedAggregationCursor = getPaginatedAggregationCursor;
/**
 * @description If both `sort` and `pagination` are used default `sort.field` and `sort.order` must be provided!
 */
const createSorterWithPaginator = ({ sort, pagination, since, until }) => {
    const sorter = (0, sort_1.getSorter)(sort);
    const paginator = getLinkPaginator({
        pagination,
        since,
        until,
        sort,
    });
    if (pagination && !sort.field) {
        throw new Error('Default sort field must be provided!');
    }
    if (pagination && !sort.order) {
        throw new Error('Default sort order must be provided!');
    }
    return { sorter, paginator };
};
exports.createSorterWithPaginator = createSorterWithPaginator;
//# sourceMappingURL=pagination.js.map