import { AggregationCursor } from 'mongodb';
import { Since, Until, TPagination } from '../../../Lib/Pagination/paginationTypes';
import { ISort } from '../../../Lib/Sort/sort';
export interface IGetLinkPaginatorParams<SortField> {
    pagination?: TPagination;
    since?: Since;
    until?: Until;
    sort: ISort<SortField>;
}
interface IGetPaginatedAggregationCursorParams<T> {
    aggregationCursor: AggregationCursor<T>;
    pagination?: TPagination;
}
interface ICreateSorterWithPaginatorParams<SortField> {
    sort: ISort<SortField>;
    pagination?: TPagination;
    since?: Since;
    until?: Until;
}
export declare const getPaginatedAggregationCursor: <T>({ aggregationCursor, pagination }: IGetPaginatedAggregationCursorParams<T>) => AggregationCursor<T>;
/**
 * @description If both `sort` and `pagination` are used default `sort.field` and `sort.order` must be provided!
 */
export declare const createSorterWithPaginator: <SortField>({ sort, pagination, since, until }: ICreateSorterWithPaginatorParams<SortField>) => {
    sorter: {
        $sort: {
            [x: string]: number;
        };
    };
    paginator: {};
};
export {};
//# sourceMappingURL=pagination.d.ts.map