"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createModelReadable = void 0;
const collection_1 = require("./collection");
/**
 * Create a full readable model of an entity
 */
function createModelReadable({ collection, conn, }) {
    return {
        fetchByUid(uid) {
            return (0, collection_1.getCollection)(conn, collection).findOne({ uid }, { session: conn.session });
        },
        fetchList() {
            return (0, collection_1.getCollection)(conn, collection).find({}, { session: conn.session }).toArray();
        },
        fetchListByUids(uids) {
            return (0, collection_1.getCollection)(conn, collection)
                .find({ uid: { $in: uids } }, { session: conn.session })
                .toArray();
        },
    };
}
exports.createModelReadable = createModelReadable;
//# sourceMappingURL=modelReadable.js.map