"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createModelCreatable = void 0;
const collection_1 = require("./collection");
/**
 * Create a full creatable model of an entity
 */
function createModelCreatable({ collection, conn, }) {
    return {
        create(entity) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, collection_1.getCollection)(conn, collection).insertOne(Object.assign({}, entity), { session: conn.session });
            });
        },
    };
}
exports.createModelCreatable = createModelCreatable;
//# sourceMappingURL=modelCreatable.js.map