"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createModel = void 0;
const modelReadable_1 = require("./modelReadable");
const modelCreatable_1 = require("./modelCreatable");
const modelUpdatable_1 = require("./modelUpdatable");
const modelDeletable_1 = require("./modelDeletable");
/**
 * Creates a full readable, creatable, updatable and deletable model for an entity
 */
function createModel({ collection, conn, }) {
    return Object.assign(Object.assign(Object.assign(Object.assign({}, (0, modelReadable_1.createModelReadable)({ collection, conn })), (0, modelCreatable_1.createModelCreatable)({ collection, conn })), (0, modelUpdatable_1.createModelUpdatable)({ collection, conn })), (0, modelDeletable_1.createModelDeletable)({ collection, conn }));
}
exports.createModel = createModel;
//# sourceMappingURL=model.js.map