import { IMongodbConnection } from '@signageos/lib/dist/MongoDB/mongoDBConnectionFactory';
import { IModelReadable } from '../../../Lib/Model/IModelReadable';
import { IModelCreatable } from '../../../Lib/Model/IModelCreatable';
import { IModelUpdatable } from '../../../Lib/Model/IModelUpdatable';
import { ICreatable, IEntity, IUpdatable } from '../../../Lib/Model/model';
import { IModelDeletable } from '../../../Lib/Model/IModelDeletable';
export declare type CreateModelProps = {
    collection: string;
    conn: IMongodbConnection;
};
declare type FullEntity = IEntity & ICreatable & IUpdatable;
export declare type CreateModelReturnType<TEntity extends IEntity, TFullEntity extends TEntity & FullEntity> = IModelReadable<TFullEntity> & IModelCreatable<TFullEntity> & IModelUpdatable<TFullEntity> & IModelDeletable<TEntity>;
/**
 * Creates a full readable, creatable, updatable and deletable model for an entity
 */
export declare function createModel<TEntity extends IEntity, TFullEntity extends TEntity & FullEntity>({ collection, conn, }: CreateModelProps): CreateModelReturnType<TEntity, TFullEntity>;
export {};
//# sourceMappingURL=model.d.ts.map