"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createFrontDisplayVersionModel = exports.prepareFrontDisplayVersionTable = exports.frontDisplayVersionCollection = void 0;
const bson_1 = require("bson");
const collections_1 = require("../../Lib/collections");
const frontDisplayVersionCollection = (conn) => conn.connection.collection(collections_1.Collection.FrontDisplayVersion);
exports.frontDisplayVersionCollection = frontDisplayVersionCollection;
const prepareFrontDisplayVersionTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.frontDisplayVersionCollection)(conn).createIndex('id', { name: 'id', unique: true, background: true });
    yield (0, exports.frontDisplayVersionCollection)(conn).createIndex('version', { name: 'version', unique: true, background: true });
});
exports.prepareFrontDisplayVersionTable = prepareFrontDisplayVersionTable;
const createFrontDisplayVersionModel = (conn) => ({
    create(version, createdAt) {
        return __awaiter(this, void 0, void 0, function* () {
            const id = new bson_1.ObjectId();
            const newRow = {
                _id: id,
                id: id.toHexString(),
                version,
                createdAt,
                testSuites: [],
            };
            yield (0, exports.frontDisplayVersionCollection)(conn).insertOne(newRow, { session: conn.session });
        });
    },
    fetchById(id) {
        return (0, exports.frontDisplayVersionCollection)(conn).findOne({ _id: new bson_1.ObjectId(id) }, { session: conn.session });
    },
    fetchByVersion(version) {
        return (0, exports.frontDisplayVersionCollection)(conn).findOne({ version }, { session: conn.session });
    },
    fetchAll() {
        return (0, exports.frontDisplayVersionCollection)(conn).find({}, { session: conn.session }).toArray();
    },
    setTestSuite(frontDisplayVersionRow, suiteGroup, tests) {
        return __awaiter(this, void 0, void 0, function* () {
            // remove the previous testSuite with the same name
            yield (0, exports.frontDisplayVersionCollection)(conn).updateOne({ _id: new bson_1.ObjectId(frontDisplayVersionRow.id) }, { $pull: { testSuites: { suiteType: suiteGroup.suiteType } } }, { session: conn.session });
            yield (0, exports.frontDisplayVersionCollection)(conn).updateOne({ _id: new bson_1.ObjectId(frontDisplayVersionRow.id) }, { $addToSet: { testSuites: Object.assign(Object.assign({}, suiteGroup), tests) } }, { session: conn.session });
        });
    },
    setTestSuitePassed(frontDisplayVersionRow, suiteGroup, passedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.frontDisplayVersionCollection)(conn).updateOne({
                _id: new bson_1.ObjectId(frontDisplayVersionRow.id),
                'testSuites.suiteType': suiteGroup.suiteType,
            }, {
                $set: {
                    'testSuites.$.passedAt': passedAt,
                },
                $unset: {
                    'testSuites.$.failedAt': '',
                },
            }, { session: conn.session });
        });
    },
    setTestSuiteFailed(frontDisplayVersionRow, suiteGroup, failed) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.frontDisplayVersionCollection)(conn).updateOne({
                _id: new bson_1.ObjectId(frontDisplayVersionRow.id),
                'testSuites.suiteType': suiteGroup.suiteType,
            }, {
                $set: {
                    'testSuites.$.failedAt': failed,
                },
                $unset: {
                    'testSuites.$.passedAt': '',
                },
            }, { session: conn.session });
        });
    },
    addTestPassed(frontDisplayVersionRow, suiteGroup, identification) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.frontDisplayVersionCollection)(conn).updateOne({
                _id: new bson_1.ObjectId(frontDisplayVersionRow.id),
                'testSuites.suiteType': suiteGroup.suiteType,
            }, {
                $addToSet: {
                    'testSuites.$.passedTests': identification,
                },
                $pull: {
                    'testSuites.$.pendingTests': identification,
                    'testSuites.$.failedTests': identification,
                },
            }, { session: conn.session });
        });
    },
    addTestFailed(frontDisplayVersionRow, suiteGroup, identification) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.frontDisplayVersionCollection)(conn).updateOne({
                _id: new bson_1.ObjectId(frontDisplayVersionRow.id),
                'testSuites.suiteType': suiteGroup.suiteType,
            }, {
                $addToSet: {
                    'testSuites.$.failedTests': identification,
                },
                $pull: {
                    'testSuites.$.pendingTests': identification,
                    'testSuites.$.passedTests': identification,
                },
            }, { session: conn.session });
        });
    },
});
exports.createFrontDisplayVersionModel = createFrontDisplayVersionModel;
//# sourceMappingURL=frontDisplayVersionModel.js.map