"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createFrontAppletVersionModel = exports.prepareFrontAppletVersionTable = exports.frontAppletVersionCollection = void 0;
const collections_1 = require("../../Lib/collections");
const frontAppletVersionCollection = (conn) => conn.connection.collection(collections_1.Collection.FrontAppletVersion);
exports.frontAppletVersionCollection = frontAppletVersionCollection;
const prepareFrontAppletVersionTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.frontAppletVersionCollection)(conn).createIndex('version', { name: 'version', unique: true, background: true });
});
exports.prepareFrontAppletVersionTable = prepareFrontAppletVersionTable;
const createFrontAppletVersionModel = (conn) => ({
    create(version, createdAt) {
        return __awaiter(this, void 0, void 0, function* () {
            const newRow = { version, createdAt };
            yield (0, exports.frontAppletVersionCollection)(conn).insertOne(newRow, { session: conn.session });
        });
    },
    release(version, releasedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.frontAppletVersionCollection)(conn).updateOne({ version }, {
                $set: { releasedAt },
            }, { session: conn.session });
        });
    },
    fetchByVersion(version) {
        return (0, exports.frontAppletVersionCollection)(conn).findOne({ version }, { session: conn.session });
    },
    fetchAll(onlyReleased) {
        let query = {};
        if (onlyReleased) {
            query = { releasedAt: { $exists: true } };
        }
        return (0, exports.frontAppletVersionCollection)(conn).find(query, { session: conn.session }).toArray();
    },
});
exports.createFrontAppletVersionModel = createFrontAppletVersionModel;
//# sourceMappingURL=frontAppletVersionModel.js.map