"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceTimerModel = exports.prepareDeviceTimerTable = exports.deviceTimerCollection = void 0;
const collections_1 = require("../../Lib/collections");
const deviceTimerCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.Timer);
exports.deviceTimerCollection = deviceTimerCollection;
const prepareDeviceTimerTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.deviceTimerCollection)(conn).createIndex({ uid: 1 }, { name: 'uid', unique: true, background: true });
    yield (0, exports.deviceTimerCollection)(conn).createIndex({ deviceIdentityHash: 1 }, { name: 'deviceIdentityHash', background: true });
    yield (0, exports.deviceTimerCollection)(conn).createIndex({ deviceIdentityHash: 1, type: 1, volume: 1 }, { name: 'device_type_volume', background: true });
});
exports.prepareDeviceTimerTable = prepareDeviceTimerTable;
const createDeviceTimerModel = (conn) => ({
    create(uid, device, createdAt, type, timeOn, timeOff, volume, weekdays, level) {
        return __awaiter(this, void 0, void 0, function* () {
            const timerDoc = {
                uid,
                deviceIdentityHash: device.identityHash,
                createdAt,
                type,
                timeOn,
                timeOff,
                volume,
                weekdays,
                level,
                succeededAt: null,
                postponedAt: null,
                failedAt: null,
            };
            yield (0, exports.deviceTimerCollection)(conn).insertOne(timerDoc, { session: conn.session });
        });
    },
    fetchByUid(uid) {
        return __awaiter(this, void 0, void 0, function* () {
            return (0, exports.deviceTimerCollection)(conn).findOne({ uid }, { session: conn.session });
        });
    },
    fetchByDevice(device) {
        return __awaiter(this, void 0, void 0, function* () {
            return (0, exports.deviceTimerCollection)(conn).findOne({ deviceIdentityHash: device.identityHash }, { session: conn.session });
        });
    },
    fetchFailedByDeviceList(deviceList, from) {
        return __awaiter(this, void 0, void 0, function* () {
            const query = {
                deviceIdentityHash: {
                    $in: deviceList.map((d) => d.identityHash),
                },
                failedAt: { $exists: true },
            };
            if (from) {
                query.failedAt = { $gte: from };
            }
            return (0, exports.deviceTimerCollection)(conn).find(query, { session: conn.session }).toArray();
        });
    },
    fetchLatestListByDevices(devices, level, type) {
        return __awaiter(this, void 0, void 0, function* () {
            return (0, exports.deviceTimerCollection)(conn)
                .find({
                deviceIdentityHash: {
                    $in: devices.map((d) => d.identityHash),
                },
                level,
                type,
            }, { sort: { createdAt: -1 }, session: conn.session })
                .toArray();
        });
    },
    fetchListByPropertyFilter(propertyFilter) {
        return __awaiter(this, void 0, void 0, function* () {
            const query = {};
            if (propertyFilter.deviceIdentityHash) {
                query.deviceIdentityHash = propertyFilter.deviceIdentityHash;
            }
            return (0, exports.deviceTimerCollection)(conn).find(query, { session: conn.session }).toArray();
        });
    },
    fetchLatestSucceededByDeviceAndLevelAndType(device, level, type) {
        return __awaiter(this, void 0, void 0, function* () {
            return (0, exports.deviceTimerCollection)(conn).findOne({
                deviceIdentityHash: device.identityHash,
                level,
                type,
                succeededAt: { $exists: true },
            }, { sort: { createdAt: -1 }, session: conn.session });
        });
    },
    markSucceeded(deviceTimerRow, succeededAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.deviceTimerCollection)(conn).updateOne({ uid: deviceTimerRow.uid }, { $set: { succeededAt } }, { session: conn.session });
        });
    },
    markFailed(deviceTimerRow, failedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.deviceTimerCollection)(conn).updateOne({ uid: deviceTimerRow.uid }, { $set: { failedAt } }, { session: conn.session });
        });
    },
    markPostponed(deviceTimerRow, postponedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.deviceTimerCollection)(conn).updateOne({ uid: deviceTimerRow.uid }, { $set: { postponedAt } }, { session: conn.session });
        });
    },
    countFailedByDevice(device, from) {
        return __awaiter(this, void 0, void 0, function* () {
            const query = {
                deviceIdentityHash: device.identityHash,
                failedAt: { $exists: true },
            };
            if (from) {
                query.failedAt = { $gte: from };
            }
            return yield (0, exports.deviceTimerCollection)(conn).find(query, { session: conn.session }).count();
        });
    },
});
exports.createDeviceTimerModel = createDeviceTimerModel;
//# sourceMappingURL=deviceTimerModel.js.map