"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceTestModel = exports.prepareDeviceTestTable = exports.deviceTestCollection = void 0;
const collections_1 = require("../../Lib/collections");
const deviceTestCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.Test);
exports.deviceTestCollection = deviceTestCollection;
const prepareDeviceTestTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.deviceTestCollection)(conn).createIndex({ uid: 1 }, { name: 'uid', unique: true, background: true });
    yield (0, exports.deviceTestCollection)(conn).createIndex({ deviceIdentityHash: 1 }, { name: 'deviceIdentityHash', background: true });
    yield (0, exports.deviceTestCollection)(conn).createIndex({ createdAt: -1 }, { name: 'createdAt', background: true });
    yield (0, exports.deviceTestCollection)(conn).createIndex({ deviceIdentityHash: 1, finishedAt: -1 }, { name: 'deviceIdentityHash_finishedAt', background: true });
    yield (0, exports.deviceTestCollection)(conn).createIndex({ deviceIdentityHash: 1, failedAt: -1 }, { name: 'deviceIdentityHash_failedAt', background: true });
});
exports.prepareDeviceTestTable = prepareDeviceTestTable;
const createDeviceTestModel = (conn) => ({
    fetchByUid(uid) {
        const filter = {
            uid,
        };
        return (0, exports.deviceTestCollection)(conn).findOne(filter, { session: conn.session });
    },
    fetchByDevice(device) {
        const filter = {
            deviceIdentityHash: device.identityHash,
        };
        return (0, exports.deviceTestCollection)(conn).findOne(filter, { session: conn.session });
    },
    fetchLatestByDevice(device) {
        const filter = {
            deviceIdentityHash: device.identityHash,
        };
        return (0, exports.deviceTestCollection)(conn).findOne(filter, { sort: { createdAt: -1 }, session: conn.session });
    },
    create(uid, device, tests, createdAt) {
        return __awaiter(this, void 0, void 0, function* () {
            const newRow = {
                uid,
                deviceIdentityHash: device.identityHash,
                pendingTests: tests,
                successfulTests: [],
                skippedTests: [],
                failedTests: [],
                testResults: {},
                createdAt,
            };
            yield (0, exports.deviceTestCollection)(conn).insertOne(newRow, { session: conn.session });
        });
    },
    markFinished(deviceTestRow, finishedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.deviceTestCollection)(conn).updateOne({ uid: deviceTestRow.uid }, {
                $set: {
                    finishedAt: finishedAt,
                },
            });
        });
    },
    markCanceled(deviceTestRow, canceledAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.deviceTestCollection)(conn).updateOne({ uid: deviceTestRow.uid }, {
                $set: {
                    canceledAt: canceledAt,
                },
            });
        });
    },
    markFailed(deviceTestRow, failedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.deviceTestCollection)(conn).updateOne({ uid: deviceTestRow.uid }, {
                $set: {
                    failedAt: failedAt,
                },
            });
        });
    },
    setTestSucceeded(deviceTestRow, test, testResult) {
        return __awaiter(this, void 0, void 0, function* () {
            const newTestResult = testResult ? testResult : {};
            yield (0, exports.deviceTestCollection)(conn).updateOne({ uid: deviceTestRow.uid }, {
                $push: {
                    successfulTests: test,
                },
                $pull: {
                    pendingTests: test,
                },
                $set: {
                    [`testResults.${test}`]: newTestResult,
                },
            }, { session: conn.session });
        });
    },
    setTestSkipped(deviceTestRow, test, testResult) {
        return __awaiter(this, void 0, void 0, function* () {
            const newTestResult = testResult ? testResult : {};
            yield (0, exports.deviceTestCollection)(conn).updateOne({ uid: deviceTestRow.uid }, {
                $push: {
                    skippedTests: test,
                },
                $pull: {
                    pendingTests: test,
                },
                $set: {
                    [`testResults.${test}`]: newTestResult,
                },
            }, { session: conn.session });
        });
    },
    setTestFailed(deviceTestRow, test, testResult) {
        return __awaiter(this, void 0, void 0, function* () {
            const newTestResult = testResult ? testResult : {};
            yield (0, exports.deviceTestCollection)(conn).updateOne({ uid: deviceTestRow.uid }, {
                $push: {
                    failedTests: test,
                },
                $pull: {
                    pendingTests: test,
                },
                $set: {
                    [`testResults.${test}`]: newTestResult,
                },
            }, { session: conn.session });
        });
    },
});
exports.createDeviceTestModel = createDeviceTestModel;
//# sourceMappingURL=deviceTestModel.js.map