"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceTemperatureModel = exports.prepareDeviceTemperatureTable = void 0;
const generator_1 = require("@signageos/lib/dist/Hash/generator");
const collections_1 = require("../../Lib/collections");
const deviceTemperatureCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.Temperature);
const prepareDeviceTemperatureTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield deviceTemperatureCollection(conn).createIndex({ uid: 1 }, { name: 'uid', unique: true, background: true });
    yield deviceTemperatureCollection(conn).createIndex({ deviceIdentityHash: 1 }, { name: 'deviceIdentityHash', background: true });
    yield deviceTemperatureCollection(conn).createIndex({ createdAt: 1 }, { name: 'createdAt', background: true, expireAfterSeconds: 8035200 });
    yield deviceTemperatureCollection(conn).createIndex({ deviceIdentityHash: 1, createdAt: 1 }, { name: 'deviceIdentityHash_createdAt', background: true });
});
exports.prepareDeviceTemperatureTable = prepareDeviceTemperatureTable;
const createDeviceTemperatureModel = (conn) => ({
    fetchByUid(uid) {
        return deviceTemperatureCollection(conn).findOne({ uid });
    },
    fetchListByPropertyFilter(propertyFilter, limit) {
        const filter = {};
        if (typeof propertyFilter.deviceIdentityHash !== 'undefined') {
            filter.deviceIdentityHash = propertyFilter.deviceIdentityHash;
        }
        if (typeof propertyFilter.createdSince !== 'undefined') {
            filter.createdAt = Object.assign(Object.assign({}, (filter.createdAt || {})), { $gte: propertyFilter.createdSince });
        }
        if (typeof propertyFilter.createdUntil !== 'undefined') {
            filter.createdAt = Object.assign(Object.assign({}, (filter.createdAt || {})), { $lt: propertyFilter.createdUntil });
        }
        let query = deviceTemperatureCollection(conn).find(filter, { session: conn.session });
        if (typeof limit !== 'undefined') {
            query = query.limit(limit);
        }
        query = query.sort({ createdAt: 1 });
        return query.toArray();
    },
    fetchListByDevice(device) {
        const query = deviceTemperatureCollection(conn).find({
            deviceIdentityHash: device.identityHash,
        });
        return query.sort({ createdAt: 1 }).toArray();
    },
    fetchLatestByDevice(device) {
        return deviceTemperatureCollection(conn).findOne({
            deviceIdentityHash: device.identityHash,
        }, {
            sort: { createdAt: -1 },
            limit: 1,
        });
    },
    create(device, temperature, createdAt) {
        return __awaiter(this, void 0, void 0, function* () {
            const newRow = {
                uid: (0, generator_1.generateUniqueHash)(),
                deviceIdentityHash: device.identityHash,
                temperature,
                createdAt,
            };
            yield deviceTemperatureCollection(conn).insertOne(newRow);
        });
    },
    deleteCreatedUntil(_createdUntil) {
        return __awaiter(this, void 0, void 0, function* () {
            // Not necessary in mongodb to remove old rows, because of expireAfterSeconds index on createdAt
        });
    },
});
exports.createDeviceTemperatureModel = createDeviceTemperatureModel;
//# sourceMappingURL=deviceTemperatureModel.js.map