"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceScreenshotModel = exports.prepareDeviceScreenshotTable = exports.deviceScreenshotCollection = void 0;
const mongodb_1 = require("mongodb");
const generator_1 = require("@signageos/lib/dist/Hash/generator");
const collections_1 = require("../../Lib/collections");
const FIND_OPTIONS = {
    readPreference: mongodb_1.ReadPreference.SECONDARY_PREFERRED,
};
const deviceScreenshotCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.Screenshot);
exports.deviceScreenshotCollection = deviceScreenshotCollection;
const prepareDeviceScreenshotTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.deviceScreenshotCollection)(conn).createIndex({ id: 1 }, { name: 'id', unique: true, background: true });
    yield (0, exports.deviceScreenshotCollection)(conn).createIndex({ deviceIdentityHash: 1 }, { name: 'deviceIdentityHash', background: true });
    yield (0, exports.deviceScreenshotCollection)(conn).createIndex({ takenAt: 1 }, { name: 'takenAt', background: true, expireAfterSeconds: 8035200 });
    yield (0, exports.deviceScreenshotCollection)(conn).createIndex({ deviceIdentityHash: 1, takenAt: 1 }, { name: 'deviceIdentityHash_takenAt', background: true });
});
exports.prepareDeviceScreenshotTable = prepareDeviceScreenshotTable;
const createDeviceScreenshotModel = (conn) => ({
    fetchListByPropertyFilter(propertyFilter, pagination, descending) {
        const filter = {};
        if (typeof propertyFilter.deviceIdentityHash !== 'undefined') {
            filter.deviceIdentityHash = propertyFilter.deviceIdentityHash;
        }
        if (typeof propertyFilter.takenSince !== 'undefined') {
            filter.takenAt = Object.assign(Object.assign({}, (filter.takenAt || {})), { $gte: propertyFilter.takenSince });
        }
        if (typeof propertyFilter.takenUntil !== 'undefined') {
            filter.takenAt = Object.assign(Object.assign({}, (filter.takenAt || {})), { $lt: propertyFilter.takenUntil });
        }
        let query = (0, exports.deviceScreenshotCollection)(conn).find(filter, FIND_OPTIONS);
        query = query.sort({ takenAt: descending ? -1 : 1 });
        if (typeof (pagination === null || pagination === void 0 ? void 0 : pagination.limit) !== 'undefined') {
            query = query.limit(pagination.limit);
        }
        if (typeof (pagination === null || pagination === void 0 ? void 0 : pagination.offset) !== 'undefined') {
            query = query.skip(pagination.offset);
        }
        return query.toArray();
    },
    countByPropertyFilter(propertyFilter) {
        return __awaiter(this, void 0, void 0, function* () {
            const filter = {};
            if (typeof propertyFilter.deviceIdentityHash !== 'undefined') {
                filter.deviceIdentityHash = propertyFilter.deviceIdentityHash;
            }
            if (typeof propertyFilter.takenSince !== 'undefined') {
                filter.takenAt = Object.assign(Object.assign({}, (filter.takenAt || {})), { $gte: propertyFilter.takenSince });
            }
            if (typeof propertyFilter.takenUntil !== 'undefined') {
                filter.takenAt = Object.assign(Object.assign({}, (filter.takenAt || {})), { $lt: propertyFilter.takenUntil });
            }
            return yield (0, exports.deviceScreenshotCollection)(conn).countDocuments(filter, FIND_OPTIONS);
        });
    },
    create(deviceIdentityHash, uri, takenAt) {
        return __awaiter(this, void 0, void 0, function* () {
            const newRow = {
                id: (0, generator_1.generateUniqueHash)(),
                deviceIdentityHash,
                uri,
                takenAt,
            };
            yield (0, exports.deviceScreenshotCollection)(conn).insertOne(newRow);
        });
    },
    fetchLatestByDevice(deviceRow) {
        return (0, exports.deviceScreenshotCollection)(conn).findOne({
            deviceIdentityHash: deviceRow.identityHash,
        }, Object.assign(Object.assign({}, FIND_OPTIONS), { sort: { takenAt: -1 }, limit: 1 }));
    },
    fetchLatestByDeviceIdentityHashes(deviceIdentityHashes) {
        return __awaiter(this, void 0, void 0, function* () {
            const screenshots = [];
            for (const deviceIdentityHash of deviceIdentityHashes) {
                const screenshot = yield (0, exports.deviceScreenshotCollection)(conn).findOne({
                    deviceIdentityHash,
                }, Object.assign(Object.assign({}, FIND_OPTIONS), { sort: { takenAt: -1 } }));
                if (screenshot !== null) {
                    screenshots.push(screenshot);
                }
            }
            return screenshots;
        });
    },
    fetchScreenshotHistoryByDeviceAndLimit(deviceRow, limit) {
        const filter = {
            deviceIdentityHash: deviceRow.identityHash,
        };
        let query = (0, exports.deviceScreenshotCollection)(conn).find(filter, FIND_OPTIONS);
        if (typeof limit !== 'undefined') {
            query = query.limit(limit);
        }
        return query.sort({ takenAt: -1 }).toArray();
    },
    deleteTakenUntil(_takenUntil) {
        return __awaiter(this, void 0, void 0, function* () {
            // Not necessary in mongodb to remove old rows, because of expireAfterSeconds index on takenAt
        });
    },
});
exports.createDeviceScreenshotModel = createDeviceScreenshotModel;
//# sourceMappingURL=deviceScreenshotModel.js.map