"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceProvisioningRecipeModel = exports.prepareDeviceProvisioningRecipeTable = exports.deviceProvisioningRecipeCollection = void 0;
const model_1 = require("../../Lib/Model/model");
const collections_1 = require("../../Lib/collections");
const utils_1 = require("../../Lib/utils");
const deviceProvisioningRecipe_utils_1 = require("../../../Schema/Device/ProvisioningRecipe/deviceProvisioningRecipe.utils");
const lodash_1 = require("lodash");
const deviceProvisioningRecipeCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.DeviceProvisioningRecipe);
exports.deviceProvisioningRecipeCollection = deviceProvisioningRecipeCollection;
const prepareDeviceProvisioningRecipeTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.deviceProvisioningRecipeCollection)(conn).createIndex({ uid: 1 }, { unique: true, background: true });
    yield (0, exports.deviceProvisioningRecipeCollection)(conn).createIndex({ organizationUid: 1 }, { background: true });
    yield (0, exports.deviceProvisioningRecipeCollection)(conn).createIndex({ deviceUid: 1 }, { background: true });
    // For majority of device brands
    yield (0, exports.deviceProvisioningRecipeCollection)(conn).createIndex({ brand: 1, serialNumber: 1 }, { background: true });
    // For some device brands
    yield (0, exports.deviceProvisioningRecipeCollection)(conn).createIndex({ brand: 1, model: 1, serialNumber: 1 }, { background: true });
});
exports.prepareDeviceProvisioningRecipeTable = prepareDeviceProvisioningRecipeTable;
const createMatcherFromPropertyFilter = (filter) => {
    const filterQuery = {};
    if (filter === null || filter === void 0 ? void 0 : filter.organizationUids) {
        filterQuery.organizationUid = { $in: filter.organizationUids };
    }
    if (filter === null || filter === void 0 ? void 0 : filter.search) {
        const searchProperties = ['deviceName', 'serialNumber', 'macAddress', 'model', 'brand'];
        filterQuery.$or = searchProperties.map((property) => ({
            [property]: { $regex: (0, lodash_1.escapeRegExp)(filter.search), $options: 'i' },
        }));
    }
    if (filter === null || filter === void 0 ? void 0 : filter.status) {
        filterQuery.status = { $eq: filter.status };
    }
    if (filter === null || filter === void 0 ? void 0 : filter.brand) {
        filterQuery.brand = { $eq: filter.brand };
    }
    if (filter === null || filter === void 0 ? void 0 : filter.tagUids) {
        filterQuery.tagUids = { $in: filter.tagUids };
    }
    if (filter === null || filter === void 0 ? void 0 : filter.policyUids) {
        filterQuery.policyUid = { $in: filter.policyUids };
    }
    if (filter === null || filter === void 0 ? void 0 : filter.locationUids) {
        filterQuery.locationUid = { $in: filter.locationUids };
    }
    if (filter === null || filter === void 0 ? void 0 : filter.serialNumber) {
        filterQuery.serialNumber = { $eq: filter.serialNumber };
    }
    if (filter === null || filter === void 0 ? void 0 : filter.model) {
        filterQuery.model = { $eq: filter.model };
    }
    if (filter === null || filter === void 0 ? void 0 : filter.macAddress) {
        const macAddresses = Array.isArray(filter.macAddress) ? filter.macAddress : [filter.macAddress];
        filterQuery.macAddress = { $in: macAddresses };
    }
    return filterQuery;
};
const createMatcherFromPropertyFilters = (filters) => {
    return filters && filters.length > 0 ? { $or: filters.map((filter) => createMatcherFromPropertyFilter(filter)) } : {};
};
const createDeviceProvisioningRecipeModel = (conn) => {
    return Object.assign(Object.assign({}, (0, model_1.createModel)({
        conn,
        collection: collections_1.DeviceCollection.DeviceProvisioningRecipe,
    })), { fetchByDeviceUid: (deviceUid) => __awaiter(void 0, void 0, void 0, function* () {
            return (0, exports.deviceProvisioningRecipeCollection)(conn).findOne({ deviceUid }, { session: conn.session });
        }), fetchListByFilters: (filters, paginationAndSorting) => __awaiter(void 0, void 0, void 0, function* () {
            const matcher = createMatcherFromPropertyFilters(filters);
            const sorting = (0, deviceProvisioningRecipe_utils_1.getSortingHelper)(paginationAndSorting === null || paginationAndSorting === void 0 ? void 0 : paginationAndSorting.sorting);
            const pipeline = (0, utils_1.getPipeline)({ matcher, sorting, pagination: paginationAndSorting === null || paginationAndSorting === void 0 ? void 0 : paginationAndSorting.pagination });
            return (0, exports.deviceProvisioningRecipeCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
        }), countByFilters: (filters) => __awaiter(void 0, void 0, void 0, function* () {
            const matcher = createMatcherFromPropertyFilters(filters);
            return (0, exports.deviceProvisioningRecipeCollection)(conn).countDocuments(matcher, { session: conn.session });
        }), countEmptyFiledsByFilters: (fields, filters) => __awaiter(void 0, void 0, void 0, function* () {
            if (fields.length === 0) {
                return {};
            }
            const matcher = createMatcherFromPropertyFilters(filters);
            /**
             * Run sub-pipeline for each field to count how many documents have empty value for that field.
             * @example
             {
                deviceName: [],
                locationUid: [ { count: 2 } ],
                policyUid: [ { count: 3 } ],
             }
             */
            const $facet = fields.reduce((acc, field) => (Object.assign(Object.assign({}, acc), { [field]: [
                    {
                        $match: {
                            $or: [{ [field]: { $exists: false } }, { [field]: { $in: ['', null] } }],
                        },
                    },
                    { $count: 'count' },
                ] })), {});
            /**
             * Replaces output array of sub-pipeline with number for each field.
             * @example
             {
                deviceName: 0,
                locationUid: 2,
                policyUid: 3,
             }
             */
            const $replaceRoot = {
                newRoot: fields.reduce((acc, field) => (Object.assign(Object.assign({}, acc), { [field]: { $ifNull: [{ $arrayElemAt: [`$${field}.count`, 0] }, 0] } })), {}),
            };
            const result = yield (0, exports.deviceProvisioningRecipeCollection)(conn)
                .aggregate([{ $match: matcher }, { $facet }, { $replaceRoot }], {
                session: conn.session,
            })
                .toArray();
            return result.length > 0 ? result[0] : {};
        }) });
};
exports.createDeviceProvisioningRecipeModel = createDeviceProvisioningRecipeModel;
//# sourceMappingURL=deviceProvisioningRecipeModel.js.map