"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceInstalledPackageModel = exports.prepareDeviceInstalledPackageTable = exports.deviceInstalledPackageCollection = void 0;
const collections_1 = require("../../Lib/collections");
const deviceInstalledPackageCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.InstalledPackage);
exports.deviceInstalledPackageCollection = deviceInstalledPackageCollection;
const prepareDeviceInstalledPackageTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.deviceInstalledPackageCollection)(conn).createIndex('uid', { name: 'uid', unique: true, background: true });
    yield (0, exports.deviceInstalledPackageCollection)(conn).createIndex({ deviceIdentityHash: 1, buildHash: 1 }, { name: 'deviceIdentityHash_buildHash', unique: true, background: true });
    yield (0, exports.deviceInstalledPackageCollection)(conn).createIndex('deviceIdentityHash', { name: 'deviceIdentityHash', background: true });
    yield (0, exports.deviceInstalledPackageCollection)(conn).createIndex('createdAt', { name: 'createdAt', background: true });
    yield (0, exports.deviceInstalledPackageCollection)(conn).createIndex('buildHash', { name: 'buildHash', background: true });
    yield (0, exports.deviceInstalledPackageCollection)(conn).createIndex({ 'specs.packageName': 1 }, { name: 'specs_packageName', background: true });
});
exports.prepareDeviceInstalledPackageTable = prepareDeviceInstalledPackageTable;
const createDeviceInstalledPackageModel = (conn) => ({
    fetchByDeviceAndBuildHash(device, buildHash) {
        return (0, exports.deviceInstalledPackageCollection)(conn).findOne({ deviceIdentityHash: device.identityHash, buildHash }, { session: conn.session });
    },
    fetchListByDeviceAndPackageVersions(device, packageVersions) {
        const buildHashes = packageVersions.map((packageVersion) => packageVersion.buildHash);
        return (0, exports.deviceInstalledPackageCollection)(conn)
            .find({
            deviceIdentityHash: device.identityHash,
            buildHash: {
                $in: buildHashes,
            },
        }, { session: conn.session })
            .toArray();
    },
    fetchListByDevice(device) {
        return (0, exports.deviceInstalledPackageCollection)(conn)
            .find({ deviceIdentityHash: device.identityHash }, { session: conn.session })
            .toArray();
    },
    create(uid, device, buildHash, specs, createdAt) {
        return __awaiter(this, void 0, void 0, function* () {
            const newRow = {
                uid,
                createdAt,
                deviceIdentityHash: device.identityHash,
                buildHash,
                specs,
            };
            yield (0, exports.deviceInstalledPackageCollection)(conn).insertOne(newRow, { session: conn.session });
        });
    },
    delete(device, buildHash) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.deviceInstalledPackageCollection)(conn).deleteOne({ deviceIdentityHash: device.identityHash, buildHash }, { session: conn.session });
        });
    },
});
exports.createDeviceInstalledPackageModel = createDeviceInstalledPackageModel;
//# sourceMappingURL=deviceInstalledPackageModel.js.map