/// <reference types="mongoose/types/aggregate" />
/// <reference types="mongoose/types/callback" />
/// <reference types="mongoose/types/collection" />
/// <reference types="mongoose/types/connection" />
/// <reference types="mongoose/types/cursor" />
/// <reference types="mongoose/types/document" />
/// <reference types="mongoose/types/error" />
/// <reference types="mongoose/types/expressions" />
/// <reference types="mongoose/types/helpers" />
/// <reference types="mongoose/types/middlewares" />
/// <reference types="mongoose/types/indexes" />
/// <reference types="mongoose/types/models" />
/// <reference types="mongoose/types/mongooseoptions" />
/// <reference types="mongoose/types/pipelinestage" />
/// <reference types="mongoose/types/populate" />
/// <reference types="mongoose/types/query" />
/// <reference types="mongoose/types/schemaoptions" />
/// <reference types="mongoose/types/schematypes" />
/// <reference types="mongoose/types/session" />
/// <reference types="mongoose/types/types" />
/// <reference types="mongoose/types/utility" />
/// <reference types="mongoose/types/validation" />
/// <reference types="mongoose/types/virtuals" />
/// <reference types="mongoose" />
/// <reference types="mongoose/types/inferschematype" />
import { IMongodbConnection } from '@signageos/lib/dist/MongoDB/mongoDBConnectionFactory';
import { IDeviceMonitoringLogModelLatest, IDeviceMonitoringLogModelWrite } from '../../../Schema/Device/MonitoringLog/deviceMonitoringLogModel';
/**
 * Returns a MongoDB collection object for the `deviceMonitoringState` collection.
 * @param {IMongodbConnection} conn - IMongodbConnection - MongoDB connection object
 */
export declare const deviceMonitoringLogLatestCollection: (conn: IMongodbConnection) => import("mongoose").Collection<import("mongoose").AnyObject>;
export declare const prepareDeviceMonitoringLogLatestTable: (conn: IMongodbConnection) => Promise<void>;
/**
 * Creates device telemetry model with methods only for inserting or getting the latest values.
 * @param {IMongodbConnection} conn - IMongodbConnection - the connection to the database
 * @returns All model functions
 */
export declare const createDeviceMonitoringLogLatestModel: (conn: IMongodbConnection) => IDeviceMonitoringLogModelLatest & IDeviceMonitoringLogModelWrite;
//# sourceMappingURL=deviceMonitoringLogLatestModel.d.ts.map