"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceMonitoringLogFullModel = exports.prepareDeviceMonitoringLogFullTable = exports.deviceMonitoringLogFullCollection = exports.convertEntityToRow = exports.convertRowToEntity = void 0;
const escape_1 = require("@signageos/lib/dist/MongoDB/escape");
const versions_1 = require("../../../Helpers/versions");
const errors_1 = require("../../../Schema/Device/MonitoringLog/errors");
const dataType_1 = require("../../../Schema/Device/MonitoringLog/dataType");
const collections_1 = require("../../Lib/collections");
const DeviceTelemetryType_1 = require("@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType");
function convertRowToEntity(row) {
    return {
        id: row.id,
        deviceIdentityHash: row.metadata.deviceIdentityHash,
        organizationUid: row.metadata.organizationUid,
        type: row.metadata.type,
        createdAt: row.createdAt,
        data: row.data,
    };
}
exports.convertRowToEntity = convertRowToEntity;
function convertEntityToRow(entity) {
    return {
        id: entity.id,
        createdAt: entity.createdAt,
        data: entity.data,
        metadata: {
            type: entity.type,
            deviceIdentityHash: entity.deviceIdentityHash,
            organizationUid: entity.organizationUid,
        },
    };
}
exports.convertEntityToRow = convertEntityToRow;
/**
 * Returns a MongoDB collection object for the `deviceMonitoringLog` collection.
 * @param {IMongodbConnection} conn - IMongodbConnection - MongoDB connection object
 */
const deviceMonitoringLogFullCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.MonitoringLog);
exports.deviceMonitoringLogFullCollection = deviceMonitoringLogFullCollection;
const prepareDeviceMonitoringLogFullTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b;
    const collectionsCursor = conn.connection.db.listCollections({ name: collections_1.DeviceCollection.MonitoringLog });
    const collection = yield collectionsCursor.next();
    const createCollection = !collection || collection.type !== 'timeseries';
    if (collection && collection.type !== 'timeseries') {
        // TODO remove this drop collection once all collections are migrated to timeseries
        yield ((_a = conn.connection) === null || _a === void 0 ? void 0 : _a.db.dropCollection(collections_1.DeviceCollection.MonitoringLog));
    }
    if (createCollection) {
        yield ((_b = conn.connection) === null || _b === void 0 ? void 0 : _b.db.createCollection(collections_1.DeviceCollection.MonitoringLog, {
            timeseries: {
                timeField: 'createdAt',
                metaField: 'metadata',
                granularity: 'minutes',
            },
            expireAfterSeconds: 60 * 60 * 24 * 30 * 6, // 6 months
        }));
    }
    yield (0, exports.deviceMonitoringLogFullCollection)(conn).createIndex({ 'metadata.deviceIdentityHash': 1 }, { name: 'device', background: true });
    yield (0, exports.deviceMonitoringLogFullCollection)(conn).createIndex({ 'metadata.deviceIdentityHash': 1, 'metadata.type': 1 }, { name: 'device_type', background: true });
    yield (0, exports.deviceMonitoringLogFullCollection)(conn).createIndex({ 'metadata.deviceIdentityHash': 1, 'metadata.type': 1, createdAt: -1 }, { name: 'device_type_createdAt', background: true });
});
exports.prepareDeviceMonitoringLogFullTable = prepareDeviceMonitoringLogFullTable;
/**
 * Creates device telemetry model with all methods for fetching, writing, and getting values from database.
 * @param {IMongodbConnection} conn - IMongodbConnection - the connection to the database
 * @returns All model functions
 */
const createDeviceMonitoringLogFullModel = (conn) => ({
    fetchById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            const row = yield (0, exports.deviceMonitoringLogFullCollection)(conn).findOne({ id }, { session: conn.session });
            return row ? convertRowToEntity(row) : null;
        });
    },
    fetchLatestByDeviceAndType(device, type) {
        return __awaiter(this, void 0, void 0, function* () {
            const filter = {
                'metadata.deviceIdentityHash': device.identityHash,
                'metadata.type': type,
            };
            const options = {
                sort: { createdAt: -1 },
                session: conn.session,
            };
            const row = yield (0, exports.deviceMonitoringLogFullCollection)(conn).findOne(filter, options);
            return row ? convertRowToEntity(row) : null;
        });
    },
    fetchLatestByIdentityHashAndType(_identityHash, _type) {
        throw new Error('Not implemented');
    },
    fetchListByDevice(device, type, filter = {}) {
        return __awaiter(this, void 0, void 0, function* () {
            let pipeline = [
                {
                    $match: {
                        'metadata.deviceIdentityHash': device.identityHash,
                        'metadata.type': type,
                    },
                },
            ];
            if (filter.since || filter.until) {
                const sinceCond = filter.since ? { $gte: filter.since } : {};
                const untilCond = filter.until ? { $lte: filter.until } : {};
                pipeline.push({ $match: { createdAt: Object.assign(Object.assign({}, sinceCond), untilCond) } });
            }
            pipeline.push({ $sort: { createdAt: -1 } });
            if ('limit' in filter) {
                pipeline.push({ $limit: filter.limit });
            }
            const rows = yield (0, exports.deviceMonitoringLogFullCollection)(conn)
                .aggregate(pipeline, { session: conn.session })
                .toArray();
            return rows.map(convertRowToEntity);
        });
    },
    fetchLatestListByDevices() {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Not implemented');
        });
    },
    fetchListByDeviceAndTypeSince(device, type, since) {
        return __awaiter(this, void 0, void 0, function* () {
            const filter = {
                'metadata.deviceIdentityHash': device.identityHash,
                'metadata.type': type,
                createdAt: { $gte: since },
            };
            const options = {
                sort: { createdAt: 1 },
                session: conn.session,
            };
            const rows = yield (0, exports.deviceMonitoringLogFullCollection)(conn).find(filter, options).toArray();
            return rows.map(convertRowToEntity);
        });
    },
    fetchLastNValuesByDeviceAndType(device, type, n) {
        return __awaiter(this, void 0, void 0, function* () {
            const rows = yield (0, exports.deviceMonitoringLogFullCollection)(conn)
                .aggregate([
                {
                    $match: {
                        'metadata.deviceIdentityHash': device.identityHash,
                        'metadata.type': type,
                    },
                },
                { $sort: { createdAt: -1 } },
                { $limit: n },
                { $sort: { createdAt: 1 } },
            ])
                .toArray();
            return rows.map(convertRowToEntity);
        });
    },
    create(id, type, device, createdAt, data) {
        return __awaiter(this, void 0, void 0, function* () {
            const deviceMonitoringLog = {
                id,
                deviceIdentityHash: device.identityHash,
                organizationUid: device.organizationUid === null ? undefined : device.organizationUid,
                type,
                createdAt,
                data: (0, escape_1.escapeObject)(data),
            };
            yield this.createMany([deviceMonitoringLog]);
        });
    },
    createMany(monitoringLogs) {
        return __awaiter(this, void 0, void 0, function* () {
            const newRows = [];
            for (const monitoringLog of monitoringLogs) {
                // To standardize application version with fields in device model which are stored also as number to simplify filtering
                if (monitoringLog.type === DeviceTelemetryType_1.DeviceTelemetryType.APPLICATION_VERSION) {
                    const appVersionData = monitoringLog.data;
                    try {
                        appVersionData.versionNumber = (0, versions_1.numberizeStrictly)(appVersionData.version);
                    }
                    catch (error) {
                        throw new errors_1.InvalidMonitoringLogPropertyValueError('version', dataType_1.DataType.STRING, appVersionData.version);
                    }
                }
                const newRow = convertEntityToRow(monitoringLog);
                newRows.push(newRow);
            }
            yield (0, exports.deviceMonitoringLogFullCollection)(conn).insertMany(newRows, { session: conn.session });
        });
    },
    invalidate() {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Not implemented');
        });
    },
    fetchUptimeByOrganization(_organizationUid, _start, _stop) {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Not implemented');
        });
    },
    fetchUptimeByIdentityHash(_identityHash, _start, _stop) {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Not implemented');
        });
    },
    fetchDevicesStatusCount(_start, _stop, _organizationUids) {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Not implemented');
        });
    },
    fetchOfflineDeviceIdentityHashes(_start, _stop, _organizationUids) {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Not implemented');
        });
    },
    fetchLatelyWentOnlineDeviceIdentityHashes(_start, _stop, _organizationUids) {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Not implemented');
        });
    },
    fetchLatestByDevicesAndType(_deviceIdentityHashes, _type) {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Not implemented');
        });
    },
    fetchMonitoringLogListByDevice(_device, _type, _since, _until, _limit) {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Not implemented');
        });
    },
    fetchList(_params) {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Not implemented');
        });
    },
});
exports.createDeviceMonitoringLogFullModel = createDeviceMonitoringLogFullModel;
//# sourceMappingURL=deviceMonitoringLogFullModel.js.map