"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceCounterModel = exports.prepareDeviceCounterFailedActionTable = exports.prepareDeviceCounterScreenshotTable = exports.deviceCounterFailedActionCollection = exports.deviceCounterScreenshotCollection = void 0;
const moment = require("moment");
const collections_1 = require("../../Lib/collections");
const deviceCounterScreenshotCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.CounterScreenshot);
exports.deviceCounterScreenshotCollection = deviceCounterScreenshotCollection;
const deviceCounterFailedActionCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.CounterFailedAction);
exports.deviceCounterFailedActionCollection = deviceCounterFailedActionCollection;
const prepareDeviceCounterTable = (collection) => __awaiter(void 0, void 0, void 0, function* () {
    yield collection.createIndex({ identityHash: 1, beginAt: -1, endAt: -1 }, { name: 'identityHash_beginAt_endAt', unique: true, background: true });
    yield collection.createIndex({ identityHash: 1, endAt: -1 }, { name: 'identityHash_endAt', unique: true, background: true });
    yield collection.createIndex({ storedUntil: 1 }, { name: 'storedUntil_TTL_INDEX', expireAfterSeconds: 0, background: true });
});
const prepareDeviceCounterScreenshotTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield prepareDeviceCounterTable((0, exports.deviceCounterScreenshotCollection)(conn));
});
exports.prepareDeviceCounterScreenshotTable = prepareDeviceCounterScreenshotTable;
const prepareDeviceCounterFailedActionTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield prepareDeviceCounterTable((0, exports.deviceCounterFailedActionCollection)(conn));
});
exports.prepareDeviceCounterFailedActionTable = prepareDeviceCounterFailedActionTable;
const SCREENSHOT_TTL_IN_SECONDS = 48 * 3600;
const FAILED_ACTION_TTL_IN_SECONDS = 48 * 3600;
const createDeviceCounterModel = (conn) => {
    const countItemsInInterval = (collection, identityHash, since, until) => __awaiter(void 0, void 0, void 0, function* () {
        var _a, _b;
        const result = yield collection
            .aggregate([
            { $match: { identityHash, beginAt: { $lte: until }, endAt: { $gte: since } } },
            { $sort: { beginAt: -1, endAt: -1 } },
            { $group: { _id: null, total: { $sum: '$counter' } } },
        ], { session: conn.session })
            .toArray();
        return (_b = (_a = result === null || result === void 0 ? void 0 : result[0]) === null || _a === void 0 ? void 0 : _a.total) !== null && _b !== void 0 ? _b : 0;
    });
    const countItemsSince = (collection, identityHash, since) => __awaiter(void 0, void 0, void 0, function* () {
        var _c, _d;
        const result = yield collection
            .aggregate([
            { $match: { identityHash, endAt: { $gte: since } } },
            { $sort: { endAt: -1 } },
            { $group: { _id: null, total: { $sum: '$counter' } } },
        ], { session: conn.session })
            .toArray();
        return (_d = (_c = result === null || result === void 0 ? void 0 : result[0]) === null || _c === void 0 ? void 0 : _c.total) !== null && _d !== void 0 ? _d : 0;
    });
    const increaseItemsCounter = (collection, identityHash, now, ttl) => __awaiter(void 0, void 0, void 0, function* () {
        const beginAtMoment = moment(now)
            .minutes(Math.floor(moment(now).minutes() / 5) * 5)
            .seconds(0)
            .milliseconds(0);
        const beginAt = beginAtMoment.toDate();
        const endAt = moment(beginAtMoment).add(5, 'minutes').toDate();
        const storedUntil = moment(beginAtMoment).add(ttl, 'seconds').toDate();
        yield collection.updateOne({ identityHash, beginAt: { $lte: now }, endAt: { $gt: now } }, {
            $setOnInsert: {
                identityHash,
                beginAt,
                endAt,
                storedUntil,
            },
            $inc: { counter: 1 },
        }, { upsert: true, session: conn.session });
    });
    return {
        countScreenshotsInInterval(identityHash, since, until) {
            return __awaiter(this, void 0, void 0, function* () {
                return yield countItemsInInterval((0, exports.deviceCounterScreenshotCollection)(conn), identityHash, since, until);
            });
        },
        countScreenshotsSince(identityHash, since) {
            return __awaiter(this, void 0, void 0, function* () {
                return yield countItemsSince((0, exports.deviceCounterScreenshotCollection)(conn), identityHash, since);
            });
        },
        countFailedActionsInInterval(identityHash, since, until) {
            return __awaiter(this, void 0, void 0, function* () {
                return yield countItemsInInterval((0, exports.deviceCounterFailedActionCollection)(conn), identityHash, since, until);
            });
        },
        countFailedActionsSince(identityHash, since) {
            return __awaiter(this, void 0, void 0, function* () {
                return yield countItemsSince((0, exports.deviceCounterFailedActionCollection)(conn), identityHash, since);
            });
        },
        increaseScreenshotCounter(identityHash, now) {
            return __awaiter(this, void 0, void 0, function* () {
                yield increaseItemsCounter((0, exports.deviceCounterScreenshotCollection)(conn), identityHash, now, SCREENSHOT_TTL_IN_SECONDS);
            });
        },
        increaseFailedActionCounter(identityHash, now) {
            return __awaiter(this, void 0, void 0, function* () {
                yield increaseItemsCounter((0, exports.deviceCounterFailedActionCollection)(conn), identityHash, now, FAILED_ACTION_TTL_IN_SECONDS);
            });
        },
    };
};
exports.createDeviceCounterModel = createDeviceCounterModel;
//# sourceMappingURL=deviceCounterModel.js.map