"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createBulkRequestedEventModel = exports.prepareBulkRequestedEventTable = exports.bulkRequestedEventCollection = void 0;
const collections_1 = require("../Lib/collections");
const bulkRequestedEventCollection = (conn) => conn.connection.collection(collections_1.Collection.BulkRequestedEvents);
exports.bulkRequestedEventCollection = bulkRequestedEventCollection;
const prepareBulkRequestedEventTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.bulkRequestedEventCollection)(conn).createIndex({ requestUid: 1 }, {
        name: 'requestUid',
        unique: true,
        background: true,
    });
});
exports.prepareBulkRequestedEventTable = prepareBulkRequestedEventTable;
const createBulkRequestedEventModel = (conn) => {
    return {
        fetchByUid(requestUid) {
            return (0, exports.bulkRequestedEventCollection)(conn).findOne({ requestUid }, { session: conn.session });
        },
        fetchOlderThan(dateTime) {
            return (0, exports.bulkRequestedEventCollection)(conn)
                .find({ createdAt: { $lte: dateTime } }, { session: conn.session })
                .toArray();
        },
        create(record) {
            return (0, exports.bulkRequestedEventCollection)(conn).insertOne(record, { session: conn.session });
        },
        delete(requestUid) {
            return (0, exports.bulkRequestedEventCollection)(conn).deleteOne({ requestUid }, { session: conn.session });
        },
    };
};
exports.createBulkRequestedEventModel = createBulkRequestedEventModel;
//# sourceMappingURL=bulkRequestedEventModel.js.map