"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createApplicationModel = void 0;
const ApplicationType_1 = require("@signageos/common-types/dist/Application/ApplicationType");
const applications = [
    {
        id: 1,
        type: ApplicationType_1.ApplicationTypeSchema.Values.sssp,
        name: 'SSSP',
    },
    {
        id: 2,
        type: ApplicationType_1.ApplicationTypeSchema.Values.tizen,
        name: 'Tizen',
    },
    {
        id: 3,
        type: ApplicationType_1.ApplicationTypeSchema.Values.webos,
        name: 'WebOS',
    },
    {
        id: 4,
        type: ApplicationType_1.ApplicationTypeSchema.Values.android,
        name: 'Android',
    },
    {
        id: 5,
        type: ApplicationType_1.ApplicationTypeSchema.Values.chrome,
        name: 'Chrome',
    },
    {
        id: 6,
        type: ApplicationType_1.ApplicationTypeSchema.Values.default,
        name: 'Default',
    },
    {
        id: 8,
        type: ApplicationType_1.ApplicationTypeSchema.Values.brightsign,
        name: 'BrightSign',
    },
    {
        id: 9,
        type: ApplicationType_1.ApplicationTypeSchema.Values.linux,
        name: 'Linux',
    },
    {
        id: 10,
        type: ApplicationType_1.ApplicationTypeSchema.Values.windows,
        name: 'Windows',
    },
    {
        id: 11,
        type: ApplicationType_1.ApplicationTypeSchema.Values.chromeos,
        name: 'ChromeOS',
    },
];
const createApplicationModel = (_conn) => ({
    fetchById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            const foundApp = applications.find((application) => application.id === id);
            if (foundApp === undefined) {
                throw new Error(`There is no application id ${id}.`);
            }
            return foundApp;
        });
    },
    fetchByType(type) {
        return __awaiter(this, void 0, void 0, function* () {
            const foundApp = applications.find((application) => application.type === type);
            if (foundApp === undefined) {
                throw new Error(`There is no application for type ${type}.`);
            }
            return foundApp;
        });
    },
    fetchAll() {
        return __awaiter(this, void 0, void 0, function* () {
            return applications;
        });
    },
});
exports.createApplicationModel = createApplicationModel;
//# sourceMappingURL=applicationModel.js.map