"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAppletVersionModel = exports.prepareAppletVersionTable = exports.appletVersionCollection = void 0;
const bson_1 = require("bson");
const frontAppletVersionModel_1 = require("../FrontApplet/Version/frontAppletVersionModel");
const collections_1 = require("../Lib/collections");
const appletVersionCollection = (conn) => conn.connection.collection(collections_1.Collection.AppletVersion);
exports.appletVersionCollection = appletVersionCollection;
const prepareAppletVersionTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.appletVersionCollection)(conn).createIndex('id', { name: 'id', unique: true, background: true });
    yield (0, exports.appletVersionCollection)(conn).createIndex('appletUid', { name: 'appletUid', background: true });
    yield (0, exports.appletVersionCollection)(conn).createIndex('version', { name: 'version', background: true });
    yield (0, exports.appletVersionCollection)(conn).createIndex({ appletUid: 1, version: 1 }, { name: 'unique_appletuid_version', unique: true, background: true });
});
exports.prepareAppletVersionTable = prepareAppletVersionTable;
const excludeBinary = { binary: 0 };
const trimBinary = (doc) => {
    if (doc) {
        // @ts-ignore - remove possibly huge field if exists
        delete doc.binary;
    }
    return doc;
};
const createAppletVersionModel = (conn) => ({
    create(applet, version, binary, frontAppletVersion, createdAt, entryFile) {
        return __awaiter(this, void 0, void 0, function* () {
            let frontAppletVersionRow = null;
            if (frontAppletVersion) {
                frontAppletVersionRow = yield (0, frontAppletVersionModel_1.createFrontAppletVersionModel)(conn).fetchByVersion(frontAppletVersion);
                if (!frontAppletVersionRow) {
                    throw new Error(`Front applet version was not found: ${frontAppletVersion}`);
                }
            }
            if (!binary && !entryFile) {
                throw new Error('Applet version must have entryFile or binary.');
            }
            if (binary && entryFile) {
                throw new Error("Applet version can't have both entryFile and binary.");
            }
            const id = new bson_1.ObjectId();
            const doc = {
                _id: id,
                id,
                appletUid: applet.uid,
                version,
                binary: binary ? binary : null,
                entryFile: entryFile ? entryFile : null,
                frontAppletVersion: frontAppletVersionRow ? frontAppletVersionRow.version : null,
                createdAt,
                updatedAt: createdAt,
                publishedSince: null,
                deprecatedSince: null,
                buildRequestUid: null,
                buildRequestedAt: null,
                builtSince: null,
                buildFailedAt: null,
                buildError: null,
            };
            yield (0, exports.appletVersionCollection)(conn).insertOne(doc, { session: conn.session });
        });
    },
    fetchById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            const doc = yield (0, exports.appletVersionCollection)(conn).findOne({ id: id }, { session: conn.session, projection: excludeBinary });
            return trimBinary(doc);
        });
    },
    fetchByAppletAndVersion(applet, version) {
        return __awaiter(this, void 0, void 0, function* () {
            const doc = yield (0, exports.appletVersionCollection)(conn).findOne({
                $and: [{ appletUid: applet.uid }, { version: version }],
            }, { session: conn.session, projection: excludeBinary });
            return trimBinary(doc);
        });
    },
    remove(doc) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.appletVersionCollection)(conn).deleteOne({ id: doc.id }, { session: conn.session });
        });
    },
    /**
     * @deprecated Will be replaced by the updateEntryFile
     */
    updateBinary(doc, binary) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.appletVersionCollection)(conn).updateOne({ id: doc.id }, {
                $set: {
                    binary: binary,
                    entryFile: null,
                },
            }, { session: conn.session });
        });
    },
    updateEntryFile(doc, entryFile) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.appletVersionCollection)(conn).updateOne({ id: doc.id }, {
                $set: {
                    entryFile,
                    binary: null,
                },
            }, { session: conn.session });
        });
    },
    updateFrontAppletVersion(doc, frontAppletVersion, updatedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            let frontAppletVersionRow = null;
            if (frontAppletVersion) {
                frontAppletVersionRow = yield (0, frontAppletVersionModel_1.createFrontAppletVersionModel)(conn).fetchByVersion(frontAppletVersion);
                if (!frontAppletVersionRow) {
                    throw new Error(`Front applet version was not found: ${frontAppletVersion}`);
                }
            }
            yield (0, exports.appletVersionCollection)(conn).updateOne({ id: doc.id }, {
                $set: {
                    frontAppletVersion: frontAppletVersionRow ? frontAppletVersionRow.version : null,
                    updatedAt: updatedAt,
                },
            }, { session: conn.session });
        });
    },
    markPublished(doc, publishedSince) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.appletVersionCollection)(conn).updateOne({ id: doc.id }, { $set: { publishedSince: publishedSince } }, { session: conn.session });
        });
    },
    markDeprecated(doc, deprecatedSince) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.appletVersionCollection)(conn).updateOne({ id: doc.id }, { $set: { deprecatedSince: deprecatedSince } }, { session: conn.session });
        });
    },
    markBuildRequested(doc, buildRequestUid, buildRequestedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.appletVersionCollection)(conn).updateOne({ id: doc.id }, {
                $set: {
                    buildRequestUid,
                    buildRequestedAt,
                    builtSince: null,
                    buildFailedAt: null,
                    buildError: null,
                },
            }, { session: conn.session });
        });
    },
    markBuilt(doc, builtSince) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.appletVersionCollection)(conn).updateOne({ id: doc.id }, {
                $set: {
                    builtSince,
                    buildFailedAt: null,
                    buildError: null,
                },
            }, { session: conn.session });
        });
    },
    markBuildFailed(doc, buildError, buildFailedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.appletVersionCollection)(conn).updateOne({ id: doc.id }, {
                $set: {
                    builtSince: null,
                    buildFailedAt: buildFailedAt,
                    buildError: buildError,
                },
            }, { session: conn.session });
        });
    },
    unmarkDeprecated(doc) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.appletVersionCollection)(conn).updateOne({ id: doc.id }, { $set: { deprecatedSince: null } }, { session: conn.session });
        });
    },
    fetchBinaryByAppletAndVersion(applet, version) {
        return __awaiter(this, void 0, void 0, function* () {
            const doc = yield (0, exports.appletVersionCollection)(conn).findOne({
                $and: [{ appletUid: applet.uid }, { version: version }],
            }, { session: conn.session });
            // binary is deprecated but some documents contain it
            if (doc && doc.binary) {
                return doc.binary || undefined;
            }
            return undefined;
        });
    },
    fetchListByApplet(applet) {
        return __awaiter(this, void 0, void 0, function* () {
            const docs = yield (0, exports.appletVersionCollection)(conn)
                .find({
                appletUid: applet.uid,
            }, { session: conn.session, projection: excludeBinary })
                .toArray();
            return docs.map((doc) => trimBinary(doc));
        });
    },
    fetchLastByApplet(applet) {
        return __awaiter(this, void 0, void 0, function* () {
            const doc = yield (0, exports.appletVersionCollection)(conn).findOne({
                appletUid: applet.uid,
            }, {
                sort: {
                    createdAt: -1,
                    _id: -1,
                },
                session: conn.session,
                projection: excludeBinary,
            });
            return trimBinary(doc);
        });
    },
});
exports.createAppletVersionModel = createAppletVersionModel;
//# sourceMappingURL=appletVersionModel.js.map