"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAppletTestSuiteModel = exports.prepareAppletTestSuiteTable = exports.appletTestSuiteCollection = void 0;
const bson_1 = require("bson");
const appletVersionModel_1 = require("./appletVersionModel");
const collections_1 = require("../Lib/collections");
const appletTestSuiteCollection = (conn) => conn.connection.collection(collections_1.Collection.AppletTestSuite);
exports.appletTestSuiteCollection = appletTestSuiteCollection;
const prepareAppletTestSuiteTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.appletTestSuiteCollection)(conn).createIndex('id', { name: 'id', unique: true, background: true });
    yield (0, exports.appletTestSuiteCollection)(conn).createIndex('appletUid', { name: 'appletUid', background: true });
    yield (0, exports.appletTestSuiteCollection)(conn).createIndex('appletVersion', { name: 'appletVersion', background: true });
    yield (0, exports.appletTestSuiteCollection)(conn).createIndex('identifier', { name: 'identifier', background: true });
});
exports.prepareAppletTestSuiteTable = prepareAppletTestSuiteTable;
const createAppletTestSuiteModel = (conn) => ({
    create(appletVersion, identifier, binary, createdAt) {
        return __awaiter(this, void 0, void 0, function* () {
            const appletVersionRow = yield (0, appletVersionModel_1.createAppletVersionModel)(conn).fetchById(appletVersion.id);
            if (!appletVersionRow) {
                throw new Error(`Applet version was not found: ${appletVersion.id}`);
            }
            const id = new bson_1.ObjectId();
            const doc = {
                _id: id,
                id,
                appletUid: appletVersion.appletUid,
                appletVersion: appletVersion.version,
                identifier,
                binary,
                createdAt,
                updatedAt: createdAt,
            };
            yield (0, exports.appletTestSuiteCollection)(conn).insertOne(doc, { session: conn.session });
        });
    },
    fetchOneById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield (0, exports.appletTestSuiteCollection)(conn).findOne({ id: id }, { session: conn.session });
        });
    },
    fetchOne(appletVersion, identifier) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield (0, exports.appletTestSuiteCollection)(conn).findOne({
                appletUid: appletVersion.appletUid,
                appletVersion: appletVersion.version,
                identifier,
            }, { session: conn.session });
        });
    },
    fetchAllOf(appletVersion) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield (0, exports.appletTestSuiteCollection)(conn)
                .find({
                appletUid: appletVersion.appletUid,
                appletVersion: appletVersion.version,
            }, { session: conn.session })
                .toArray();
        });
    },
    remove(doc) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.appletTestSuiteCollection)(conn).deleteOne({ id: doc.id }, { session: conn.session });
        });
    },
    update(appletTestSuiteRow, binary, updatedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.appletTestSuiteCollection)(conn).updateOne({ id: appletTestSuiteRow.id }, {
                $set: {
                    binary,
                    updatedAt,
                },
            }, { session: conn.session });
        });
    },
});
exports.createAppletTestSuiteModel = createAppletTestSuiteModel;
//# sourceMappingURL=appletTestSuiteModel.js.map