"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAlertModel = exports.prepareAlertTable = exports.alertCollection = void 0;
const escape_1 = require("@signageos/lib/dist/MongoDB/escape");
const collections_1 = require("../Lib/collections");
const lodash_1 = require("lodash");
const getSnoozedDeviceElemMatch = (deviceIdentityHash) => ({
    $elemMatch: {
        deviceIdentityHash: deviceIdentityHash,
        'snoozeRule.snoozedUntil': { $gt: new Date() },
    },
});
const getFilterStatus = (filter, deviceIdentityHash) => {
    const mongoFilter = [];
    if ((filter === null || filter === void 0 ? void 0 : filter.includeActive) !== undefined && filter.includeActive) {
        mongoFilter.push(Object.assign({ archivedAt: null, snoozeRule: null }, (typeof deviceIdentityHash !== 'undefined'
            ? {
                deviceIdentityHashes: { $in: [deviceIdentityHash] },
                snoozedDevices: { $not: getSnoozedDeviceElemMatch(deviceIdentityHash) },
            }
            : [])));
    }
    if ((filter === null || filter === void 0 ? void 0 : filter.includeArchived) !== undefined && filter.includeArchived) {
        mongoFilter.push({
            $or: [
                Object.assign({ archivedAt: { $ne: null } }, (typeof deviceIdentityHash !== 'undefined' ? { deviceIdentityHashes: { $in: [deviceIdentityHash] } } : {})),
                ...(typeof deviceIdentityHash !== 'undefined'
                    ? [
                        {
                            'history.values.unassignedDevice.deviceIdentityHash': deviceIdentityHash,
                            deviceIdentityHashes: { $nin: [deviceIdentityHash] },
                            snoozedDevices: { $not: getSnoozedDeviceElemMatch(deviceIdentityHash) },
                        },
                    ]
                    : []),
            ],
        });
    }
    if ((filter === null || filter === void 0 ? void 0 : filter.includeSnoozed) !== undefined && filter.includeSnoozed) {
        mongoFilter.push({
            archivedAt: null,
            $or: [
                Object.assign({ snoozeRule: { $ne: null } }, (typeof deviceIdentityHash !== 'undefined' ? { deviceIdentityHashes: { $in: [deviceIdentityHash] } } : {})),
                ...(typeof deviceIdentityHash !== 'undefined'
                    ? [
                        {
                            snoozedDevices: getSnoozedDeviceElemMatch(deviceIdentityHash),
                        },
                    ]
                    : []),
            ],
        });
    }
    return mongoFilter;
};
const alertCollection = (conn) => conn.connection.collection(collections_1.Collection.Alert);
exports.alertCollection = alertCollection;
const prepareAlertTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.alertCollection)(conn).createIndex({ alertUid: 1 }, { name: 'uid', unique: true, background: true });
    yield (0, exports.alertCollection)(conn).createIndex({ organizationUid: 1 }, { name: 'organization', background: true });
    yield (0, exports.alertCollection)(conn).createIndex({ organizationUid: 1, alertRuleUid: 1, latelyChangedAt: -1 }, { name: 'organizationUid_alertRuleUid_latelyChangedAt', background: true });
    yield (0, exports.alertCollection)(conn).createIndex({ deviceIdentityHashes: 1 }, { name: 'devices', background: true });
    yield (0, exports.alertCollection)(conn).createIndex({ organizationUid: 1, snoozeRule: 1, archivedAt: 1 }, { name: 'organizationUid_snoozeRule_archivedAt', background: true });
});
exports.prepareAlertTable = prepareAlertTable;
const appendHistoryItem = (values, updatedAt, originator) => ({
    $push: { history: { values, updatedAt, originator } },
});
const createAlertModel = (conn) => {
    const updateAlert = (alertRow, update) => (0, exports.alertCollection)(conn).updateOne({ alertUid: alertRow.alertUid }, update, { session: conn.session });
    const propertyFilterToStages = (filter, deviceIdentityHash) => {
        const $match = {};
        if (filter.alertTypes) {
            $match['alertRule.alertType'] = { $in: filter.alertTypes };
        }
        if (typeof filter.description === 'string') {
            $match.description = { $regex: (0, lodash_1.escapeRegExp)(filter.description), $options: 'i' };
        }
        if (typeof filter.hasDevices !== 'undefined') {
            if (filter.hasDevices) {
                $match['deviceIdentityHashes.0'] = { $exists: true };
            }
            else {
                $match.deviceIdentityHashes = { $size: 0 };
            }
        }
        const filterStatus = getFilterStatus(filter, deviceIdentityHash);
        if (Object.keys($match).length > 0 || filterStatus.length > 0) {
            return [
                {
                    $match: Object.assign(Object.assign({}, $match), (filterStatus.length > 0 && { $or: filterStatus })),
                },
            ];
        }
        return [];
    };
    return {
        fetchByUid(alertUid) {
            return (0, exports.alertCollection)(conn).findOne({ alertUid }, { session: conn.session });
        },
        fetchListByOrganization(options) {
            var _a, _b, _c;
            let pipeline = [];
            if (options.filter) {
                const { organization, isArchived, isSnoozed } = options.filter;
                pipeline.push({
                    $match: Object.assign({ organizationUid: organization.uid }, isArchived !== undefined ? { archivedAt: isArchived ? { $ne: null } : null } : {}, isSnoozed !== undefined ? { snoozeRule: isSnoozed ? { $ne: null } : null } : {}),
                });
            }
            if (options.orderBy) {
                pipeline.push({ $sort: options.orderBy });
            }
            if ((_a = options.filter) === null || _a === void 0 ? void 0 : _a.createdUntil) {
                pipeline.push({ $match: { createdAt: { $lt: options.filter.createdUntil } } });
            }
            if ((_b = options.pagination) === null || _b === void 0 ? void 0 : _b.offset) {
                pipeline.push({ $skip: options.pagination.offset });
            }
            if ((_c = options.pagination) === null || _c === void 0 ? void 0 : _c.limit) {
                pipeline.push({ $limit: options.pagination.limit });
            }
            return (0, exports.alertCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
        },
        fetchListByOrganizations(organizations, filter, sorter, pagination) {
            const organizationUidList = organizations.map((organization) => organization.uid);
            const options = { session: conn.session };
            const filterStatus = getFilterStatus(filter || {});
            let pipeline = [
                {
                    $match: Object.assign({ organizationUid: { $in: organizationUidList } }, (filterStatus.length > 0 && { $or: filterStatus })),
                },
                {
                    $lookup: {
                        from: 'alertRule',
                        foreignField: 'alertRuleUid',
                        localField: 'alertRuleUid',
                        as: 'alertRule',
                    },
                },
                { $sort: { alertUid: 1, latelyChangedAt: 1, _id: 1 } },
            ];
            if (typeof filter !== 'undefined' && filter.alertTypes) {
                pipeline = [...pipeline, { $match: { 'alertRule.alertType': { $in: filter.alertTypes } } }];
            }
            if (typeof filter !== 'undefined' && filter.description) {
                pipeline = [...pipeline, { $match: { description: { $regex: (0, lodash_1.escapeRegExp)(filter.description), $options: 'i' } } }];
            }
            if (typeof (filter === null || filter === void 0 ? void 0 : filter.hasDevices) !== 'undefined') {
                pipeline = [...pipeline, { $match: { deviceIdentityHashes: filter.hasDevices ? { $size: { $gt: 0 } } : { $size: 0 } } }];
            }
            if (typeof sorter !== 'undefined') {
                const sortDirection = sorter.direction === 'descending' ? -1 : 1;
                switch (sorter.field) {
                    case 'description':
                        pipeline = [...pipeline, { $sort: { description: sortDirection } }];
                        break;
                    case 'organizationTitle':
                        pipeline = [
                            ...pipeline,
                            {
                                $lookup: {
                                    from: 'organization',
                                    localField: 'organizationUid',
                                    foreignField: 'uid',
                                    as: 'organization',
                                },
                            },
                            { $sort: { 'organization.title': sortDirection } },
                        ];
                        break;
                    case 'deviceIdentityHashes':
                        pipeline = [
                            ...pipeline,
                            {
                                $addFields: {
                                    deviceCount: { $size: '$deviceIdentityHashes' },
                                },
                            },
                            { $sort: { deviceCount: sortDirection } },
                        ];
                        break;
                    case 'createdAt':
                        pipeline = [...pipeline, { $sort: { createdAt: sortDirection } }];
                        break;
                    case 'latelyChangedAt':
                        pipeline = [...pipeline, { $sort: { latelyChangedAt: sortDirection } }];
                        break;
                    default:
                        break;
                }
            }
            if (typeof pagination !== 'undefined' && pagination.offset) {
                pipeline = [...pipeline, { $skip: pagination.offset }];
            }
            if (typeof pagination !== 'undefined' && pagination.limit) {
                pipeline = [...pipeline, { $limit: pagination.limit }];
            }
            return (0, exports.alertCollection)(conn).aggregate(pipeline, options).toArray();
        },
        fetchListByOrganizationsAndDeviceIdentityHashes(organizations, deviceIdentityHashes) {
            const organizationUidList = organizations.map((organization) => organization.uid);
            const options = { session: conn.session };
            let pipeline = [
                {
                    $match: {
                        organizationUid: { $in: organizationUidList },
                        deviceIdentityHashes: { $in: deviceIdentityHashes },
                    },
                },
                { $sort: { alertUid: 1, latelyChangedAt: 1, _id: 1 } },
            ];
            return (0, exports.alertCollection)(conn).aggregate(pipeline, options).toArray();
        },
        fetchLastActiveByOrganizationUidAndRule(organizationUid, alertRule) {
            return (0, exports.alertCollection)(conn).findOne({ organizationUid, alertRuleUid: alertRule.alertRuleUid, snoozeRule: null, archivedAt: null }, { sort: [['createdAt', -1]], session: conn.session });
        },
        countByOrganizations(organizations, filter) {
            var _a;
            return __awaiter(this, void 0, void 0, function* () {
                const organizationUidList = organizations.map((organization) => organization.uid);
                const options = { session: conn.session };
                const pipeline = [
                    { $match: { organizationUid: { $in: organizationUidList } } },
                    { $sort: { alertUid: 1, latelyChangedAt: 1, _id: 1 } },
                    {
                        $lookup: {
                            from: 'alertRule',
                            foreignField: 'alertRuleUid',
                            localField: 'alertRuleUid',
                            as: 'alertRule',
                        },
                    },
                ];
                if (typeof filter !== 'undefined') {
                    pipeline.push(...propertyFilterToStages(filter));
                }
                pipeline.push({ $count: 'count' });
                const [result] = yield (0, exports.alertCollection)(conn).aggregate(pipeline, options).toArray();
                return (_a = result === null || result === void 0 ? void 0 : result.count) !== null && _a !== void 0 ? _a : 0;
            });
        },
        countByDeviceIdentityHash(deviceIdentityHash, filter) {
            var _a;
            return __awaiter(this, void 0, void 0, function* () {
                const pipeline = [];
                if (typeof filter !== 'undefined') {
                    pipeline.push(...propertyFilterToStages(filter, deviceIdentityHash));
                }
                else {
                    pipeline.push({ $match: { deviceIdentityHashes: deviceIdentityHash } });
                }
                pipeline.push({ $count: 'count' });
                const [result] = yield (0, exports.alertCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
                return (_a = result === null || result === void 0 ? void 0 : result.count) !== null && _a !== void 0 ? _a : 0;
            });
        },
        countByDeviceIdentityHashes(deviceIdentityHashes, filter) {
            var _a;
            return __awaiter(this, void 0, void 0, function* () {
                const pipeline = [{ $match: { deviceIdentityHashes: { $in: deviceIdentityHashes } } }];
                if (typeof filter !== 'undefined') {
                    pipeline.push(...propertyFilterToStages(filter));
                }
                pipeline.push({ $count: 'count' });
                const [result] = yield (0, exports.alertCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
                return (_a = result === null || result === void 0 ? void 0 : result.count) !== null && _a !== void 0 ? _a : 0;
            });
        },
        countByOrganizationAndDeviceIdentityHashes(organization, deviceIdentityHashes, filter) {
            var _a;
            return __awaiter(this, void 0, void 0, function* () {
                const pipeline = [
                    {
                        $match: {
                            deviceIdentityHashes: { $in: deviceIdentityHashes },
                            organizationUid: organization.uid,
                        },
                    },
                ];
                if (typeof filter !== 'undefined') {
                    pipeline.push(...propertyFilterToStages(filter));
                }
                pipeline.push({ $count: 'count' });
                const [result] = yield (0, exports.alertCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
                return (_a = result === null || result === void 0 ? void 0 : result.count) !== null && _a !== void 0 ? _a : 0;
            });
        },
        fetchListByDeviceIdentityHash(deviceIdentityHash, filter) {
            return __awaiter(this, void 0, void 0, function* () {
                const pipeline = [];
                if (typeof filter !== 'undefined') {
                    pipeline.push(...propertyFilterToStages(filter, deviceIdentityHash));
                }
                else {
                    pipeline.push({ $match: { deviceIdentityHashes: deviceIdentityHash } });
                }
                return yield (0, exports.alertCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
            });
        },
        countDevicesWithActiveAlertsByOrganizations(organizations, filter) {
            var _a;
            return __awaiter(this, void 0, void 0, function* () {
                const organizationUidList = organizations.map((organization) => organization.uid);
                const pipeline = [
                    { $match: { organizationUid: { $in: organizationUidList }, snoozeRule: null, archivedAt: null } },
                    {
                        $lookup: {
                            from: 'alertRule',
                            foreignField: 'alertRuleUid',
                            localField: 'alertRuleUid',
                            as: 'alertRule',
                        },
                    },
                ];
                if (typeof filter !== 'undefined') {
                    pipeline.push(...propertyFilterToStages(filter));
                }
                pipeline.push({ $unwind: '$deviceIdentityHashes' }, { $group: { _id: '$deviceIdentityHashes' } }, { $count: 'count' });
                const [result] = yield (0, exports.alertCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
                return (_a = result === null || result === void 0 ? void 0 : result.count) !== null && _a !== void 0 ? _a : 0;
            });
        },
        fetchDevicesWithActiveAlertsByOrganizations(organizations, filter) {
            return __awaiter(this, void 0, void 0, function* () {
                const organizationUidList = organizations.map((organization) => organization.uid);
                const pipeline = [
                    { $match: { organizationUid: { $in: organizationUidList }, snoozeRule: null, archivedAt: null } },
                    {
                        $lookup: {
                            from: 'alertRule',
                            foreignField: 'alertRuleUid',
                            localField: 'alertRuleUid',
                            as: 'alertRule',
                        },
                    },
                ];
                if (typeof filter !== 'undefined') {
                    pipeline.push(...propertyFilterToStages(filter));
                }
                pipeline.push({ $unwind: '$deviceIdentityHashes' }, { $group: { _id: '$deviceIdentityHashes', alertUids: { $push: '$alertUid' } } }, { $project: { _id: 0, deviceIdentityHash: '$_id', alertUids: 1 } });
                return yield (0, exports.alertCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
            });
        },
        countLocationsWithActiveAlertsByOrganizations(organizations, filter) {
            var _a;
            return __awaiter(this, void 0, void 0, function* () {
                const organizationUidList = organizations.map((organization) => organization.uid);
                const pipeline = [
                    { $match: { organizationUid: { $in: organizationUidList }, snoozeRule: null, archivedAt: null } },
                    {
                        $lookup: {
                            from: 'alertRule',
                            foreignField: 'alertRuleUid',
                            localField: 'alertRuleUid',
                            as: 'alertRule',
                        },
                    },
                ];
                if (typeof filter !== 'undefined') {
                    pipeline.push(...propertyFilterToStages(filter));
                }
                pipeline.push({ $lookup: { from: 'device', localField: 'deviceIdentityHashes', foreignField: 'identityHash', as: 'device' } }, { $unwind: '$device' }, { $group: { _id: '$device.locationUid' } }, { $match: { _id: { $ne: null } } }, { $count: 'count' });
                const [result] = yield (0, exports.alertCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
                return (_a = result === null || result === void 0 ? void 0 : result.count) !== null && _a !== void 0 ? _a : 0;
            });
        },
        fetchLocationsWithActiveAlertsByOrganizations(organizations, filter) {
            return __awaiter(this, void 0, void 0, function* () {
                const organizationUidList = organizations.map((organization) => organization.uid);
                const pipeline = [
                    { $match: { organizationUid: { $in: organizationUidList }, snoozeRule: null, archivedAt: null } },
                    {
                        $lookup: {
                            from: 'alertRule',
                            foreignField: 'alertRuleUid',
                            localField: 'alertRuleUid',
                            as: 'alertRule',
                        },
                    },
                ];
                if (typeof filter !== 'undefined') {
                    pipeline.push(...propertyFilterToStages(filter));
                }
                pipeline.push({ $lookup: { from: 'device', localField: 'deviceIdentityHashes', foreignField: 'identityHash', as: 'device' } }, { $unwind: '$device' }, {
                    $group: {
                        _id: { locationUid: '$device.locationUid', alertUid: '$alertUid' },
                        affectedDevices: { $sum: 1 },
                    },
                }, {
                    $group: {
                        _id: '$_id.locationUid',
                        activeAlerts: { $push: { alertUid: '$_id.alertUid', affectedDevices: '$affectedDevices' } },
                    },
                }, { $project: { _id: 0, locationUid: '$_id', activeAlerts: 1 } });
                return yield (0, exports.alertCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
            });
        },
        create(alertUid, organization, description, alertRule, createdAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.alertCollection)(conn).insertOne({
                    alertUid,
                    organizationUid: organization.uid,
                    description,
                    alertRuleUid: alertRule.alertRuleUid,
                    createdAt,
                    latelyChangedAt: createdAt,
                    snoozeRule: null,
                    deviceIdentityHashes: [],
                    history: [],
                    archivedAt: null,
                });
            });
        },
        updateLatelyProcessedAt(alertRow, latelyProcessedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlert(alertRow, { $set: { latelyProcessedAt } });
            });
        },
        updateDescription(alertRow, description, updatedAt, originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlert(alertRow, Object.assign({ $set: { description } }, appendHistoryItem({ description }, updatedAt, originator)));
            });
        },
        assignDevice(alertRow, deviceIdentityHash, assignedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlert(alertRow, {
                    $set: { latelyChangedAt: assignedAt },
                    $addToSet: { deviceIdentityHashes: deviceIdentityHash },
                });
            });
        },
        unassignDevice(alertRow, deviceIdentityHash, unassignedAt, originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlert(alertRow, Object.assign({ $set: { latelyChangedAt: unassignedAt }, $pull: { deviceIdentityHashes: deviceIdentityHash } }, (originator ? appendHistoryItem({ unassignedDevice: { unassignedAt, deviceIdentityHash } }, unassignedAt, originator) : {})));
            });
        },
        archive(alertRow, archivedAt, originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlert(alertRow, Object.assign({ $set: { archivedAt } }, appendHistoryItem({ archivedAt }, archivedAt, originator)));
            });
        },
        unarchive(alertRow, unarchivedAt, originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlert(alertRow, Object.assign({ $set: { archivedAt: null } }, appendHistoryItem({ archivedAt: null }, unarchivedAt, originator)));
            });
        },
        snooze(alertRow, snoozeRule, snoozedAt, originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlert(alertRow, Object.assign({ $set: { snoozeRule: (0, escape_1.escapeObject)(snoozeRule) } }, appendHistoryItem({ snoozeRule }, snoozedAt, originator)));
            });
        },
        unsnooze(alertRow, unsnoozedAt, originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlert(alertRow, Object.assign({ $set: { snoozeRule: null } }, appendHistoryItem({ snoozeRule: null }, unsnoozedAt, originator)));
            });
        },
        snoozeDevice(alertRow, deviceIdentityHash, snoozeRule, snoozedAt, originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlert(alertRow, Object.assign({ $set: { latelyChangedAt: new Date() }, $addToSet: { snoozedDevices: { deviceIdentityHash, snoozeRule } } }, appendHistoryItem({ snoozedDevice: { deviceIdentityHash, snoozeRule } }, snoozedAt, originator)));
            });
        },
        unsnoozeDevice(alertRow, deviceIdentityHash, unsnoozedAt, originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlert(alertRow, Object.assign({ $set: { latelyChangedAt: unsnoozedAt }, $pull: { snoozedDevices: { deviceIdentityHash } } }, appendHistoryItem({ unsnoozedDevice: { deviceIdentityHash, unsnoozedAt } }, unsnoozedAt, originator)));
            });
        },
    };
};
exports.createAlertModel = createAlertModel;
//# sourceMappingURL=alertModel.js.map