"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createInMemoryModel = void 0;
const InMemoryStorage_1 = require("./InMemoryStorage");
const ModelDeletable_1 = require("./ModelDeletable");
const ModelCreatable_1 = require("./ModelCreatable");
const ModelReadable_1 = require("./ModelReadable");
const ModelUpdatable_1 = require("./ModelUpdatable");
/**
 * Creates an in-memory implementation of the entity model
 */
function createInMemoryModel() {
    const storage = new InMemoryStorage_1.InMemoryStorage();
    const modelReadable = (0, ModelReadable_1.createModelReadable)(storage);
    const modelCreatable = (0, ModelCreatable_1.createModelCreatable)(storage);
    const modelUpdatable = (0, ModelUpdatable_1.createModelUpdatable)(storage);
    const modelDeletable = (0, ModelDeletable_1.createModelDeletable)(storage);
    return Object.assign(Object.assign(Object.assign(Object.assign({}, modelReadable), modelCreatable), modelUpdatable), modelDeletable);
}
exports.createInMemoryModel = createInMemoryModel;
//# sourceMappingURL=model.js.map