"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createModelUpdatable = void 0;
const lodash_1 = require("lodash");
function createModelUpdatable(storage) {
    return {
        update(uid, update) {
            return __awaiter(this, void 0, void 0, function* () {
                const storedEntity = storage.getByUid(uid);
                if (!storedEntity) {
                    throw new Error(`uid ${uid} not found`);
                }
                storage.update(Object.assign(Object.assign({}, storedEntity), update));
            });
        },
        unset(uid, updatedAt, unsetKeys) {
            return __awaiter(this, void 0, void 0, function* () {
                const storedEntity = storage.getByUid(uid);
                if (!storedEntity) {
                    throw new Error(`uid ${uid} not found`);
                }
                storage.update((0, lodash_1.omit)(Object.assign(Object.assign({}, storedEntity), { updatedAt }), unsetKeys));
            });
        },
    };
}
exports.createModelUpdatable = createModelUpdatable;
//# sourceMappingURL=ModelUpdatable.js.map